/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.LongValueProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI64LoadNode
extends LLVMAbstractLoadNode {
    private final LongValueProfile profile = LongValueProfile.createIdentityProfile();

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected long doI64Native(LLVMNativePointer addr) {
        return this.profile.profile(this.getLLVMMemoryCached().getI64(addr));
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"}, rewriteOn={UnexpectedResultException.class})
    protected long doI64DerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
        return this.doI64Managed(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"}, replaces={"doI64DerefHandle"})
    protected Object doGenericI64DerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doGenericI64Managed(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(limit="3", rewriteOn={UnexpectedResultException.class})
    protected long doI64Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) throws UnexpectedResultException {
        return nativeRead.readI64(addr.getObject(), addr.getOffset());
    }

    @Specialization(limit="3", replaces={"doI64Managed"})
    protected Object doGenericI64Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readGenericI64(addr.getObject(), addr.getOffset());
    }
}

