/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMAbstractLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMI16LoadNode
extends LLVMAbstractLoadNode {
    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected short doShortNative(LLVMNativePointer addr) {
        return this.getLLVMMemoryCached().getI16(addr);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected short doShortDerefHandle(LLVMNativePointer addr, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doShortManaged(this.getDerefHandleGetReceiverNode().execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    protected short doShortManaged(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI16(addr.getObject(), addr.getOffset());
    }
}

