/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ManagedMemMoveHelperNode.class)
final class ManagedMemMoveHelperNodeFactory {
    ManagedMemMoveHelperNodeFactory() {
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI64.class)
    static final class MemWriteI64NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI64 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemWriteI64NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemWriteI64 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI64NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI32.class)
    static final class MemWriteI32NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI32 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemWriteI32NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemWriteI32 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI32NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI16.class)
    static final class MemWriteI16NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI16 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemWriteI16NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemWriteI16 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI16NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteI8.class)
    static final class MemWriteI8NodeGen
    extends ManagedMemMoveHelperNode.MemWriteI8 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemWriteI8NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            super(nativeTypes, managedWrite);
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                this.doManaged(arg0Value_, arg1Value, arg2Value);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemWriteI8 create(NativeTypeLibrary nativeTypes, LLVMManagedWriteLibrary managedWrite) {
            return new MemWriteI8NodeGen(nativeTypes, managedWrite);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteNative.class)
    static final class MemWriteNativeNodeGen
    extends ManagedMemMoveHelperNode.MemWriteNative {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

        private MemWriteNativeNodeGen() {
        }

        @Override
        void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state & 1) != 0 && arg2Value == 1) {
                    this.doNativeI8(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if ((state & 2) != 0 && arg2Value == 2) {
                    this.doNativeI16(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if ((state & 4) != 0 && arg2Value == 4) {
                    this.doNativeI32(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if ((state & 8) != 0 && arg2Value == 8) {
                    this.doNativeI64(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg2Value == 1) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        this.doNativeI8(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (arg2Value == 2) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        this.doNativeI16(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (arg2Value == 4) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        this.doNativeI32(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (arg2Value == 8) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        this.doNativeI64(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemWriteNative create() {
            return new MemWriteNativeNodeGen();
        }

        public static ManagedMemMoveHelperNode.MemWriteNative getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ManagedMemMoveHelperNode.MemWriteNative.class)
        private static final class Uncached
        extends ManagedMemMoveHelperNode.MemWriteNative {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void execute(LLVMPointer arg0Value, long arg1Value, int arg2Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg2Value == 1) {
                        this.doNativeI8(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if (arg2Value == 2) {
                        this.doNativeI16(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if (arg2Value == 4) {
                        this.doNativeI32(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if (arg2Value == 8) {
                        this.doNativeI64(arg0Value_, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI64.class)
    static final class MemReadI64NodeGen
    extends ManagedMemMoveHelperNode.MemReadI64 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemReadI64NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                return this.doManaged(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemReadI64 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI64NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI32.class)
    static final class MemReadI32NodeGen
    extends ManagedMemMoveHelperNode.MemReadI32 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemReadI32NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                return this.doManaged(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemReadI32 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI32NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI16.class)
    static final class MemReadI16NodeGen
    extends ManagedMemMoveHelperNode.MemReadI16 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemReadI16NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.doManaged(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                return this.doManaged(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemReadI16 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI16NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadI8.class)
    static final class MemReadI8NodeGen
    extends ManagedMemMoveHelperNode.MemReadI8 {
        @CompilerDirectives.CompilationFinal
        private int state_;

        private MemReadI8NodeGen(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            super(nativeTypes, managedRead);
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.execute(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                this.state_ = state |= 1;
                return this.execute(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemReadI8 create(NativeTypeLibrary nativeTypes, LLVMManagedReadLibrary managedRead) {
            return new MemReadI8NodeGen(nativeTypes, managedRead);
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadNative.class)
    static final class MemReadNativeNodeGen
    extends ManagedMemMoveHelperNode.MemReadNative {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

        private MemReadNativeNodeGen() {
        }

        @Override
        long execute(LLVMPointer arg0Value, int arg1Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((state & 1) != 0 && arg1Value == 1) {
                    return this.doNativeI8(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if ((state & 2) != 0 && arg1Value == 2) {
                    return this.doNativeI16(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if ((state & 4) != 0 && arg1Value == 4) {
                    return this.doNativeI32(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                if ((state & 8) != 0 && arg1Value == 8) {
                    return this.doNativeI64(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(LLVMPointer arg0Value, int arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg1Value == 1) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        long l = this.doNativeI8(arg0Value_, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return l;
                    }
                    if (arg1Value == 2) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        long l = this.doNativeI16(arg0Value_, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return l;
                    }
                    if (arg1Value == 4) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        long l = this.doNativeI32(arg0Value_, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return l;
                    }
                    if (arg1Value == 8) {
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        long l = this.doNativeI64(arg0Value_, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                        return l;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ManagedMemMoveHelperNode.MemReadNative create() {
            return new MemReadNativeNodeGen();
        }

        public static ManagedMemMoveHelperNode.MemReadNative getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ManagedMemMoveHelperNode.MemReadNative.class)
        private static final class Uncached
        extends ManagedMemMoveHelperNode.MemReadNative {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long execute(LLVMPointer arg0Value, int arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if (arg1Value == 1) {
                        return this.doNativeI8(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if (arg1Value == 2) {
                        return this.doNativeI16(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if (arg1Value == 4) {
                        return this.doNativeI32(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                    if (arg1Value == 8) {
                        return this.doNativeI64(arg0Value_, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ManagedMemMoveHelperNode.UnitSizeNode.class)
    static final class UnitSizeNodeGen
    extends ManagedMemMoveHelperNode.UnitSizeNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private UnitSizeNodeGen() {
        }

        private boolean fallbackGuard_(int state, ManagedMemMoveHelperNode arg0Value, long arg1Value) {
            return (state & 8) != 0 || !arg0Value.supportsUnitSize(1) || !this.isDivisible(arg1Value, 1);
        }

        @Override
        int execute(ManagedMemMoveHelperNode arg0Value, long arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value.supportsUnitSize(8) && this.isDivisible(arg1Value, 8)) {
                    return this.do8(arg0Value, arg1Value);
                }
                if ((state & 2) != 0 && arg0Value.supportsUnitSize(4) && this.isDivisible(arg1Value, 4)) {
                    return this.do4(arg0Value, arg1Value);
                }
                if ((state & 4) != 0 && arg0Value.supportsUnitSize(2) && this.isDivisible(arg1Value, 2)) {
                    return this.do2(arg0Value, arg1Value);
                }
                if ((state & 8) != 0 && arg0Value.supportsUnitSize(1) && this.isDivisible(arg1Value, 1)) {
                    return this.do1(arg0Value, arg1Value);
                }
                if ((state & 0x10) != 0 && this.fallbackGuard_(state, arg0Value, arg1Value)) {
                    return this.doError(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(ManagedMemMoveHelperNode arg0Value, long arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0 && arg0Value.supportsUnitSize(8) && this.isDivisible(arg1Value, 8)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.do8(arg0Value, arg1Value);
                    return n;
                }
                if ((exclude & 2) == 0 && arg0Value.supportsUnitSize(4) && this.isDivisible(arg1Value, 4)) {
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    int n = this.do4(arg0Value, arg1Value);
                    return n;
                }
                if ((exclude & 4) == 0 && arg0Value.supportsUnitSize(2) && this.isDivisible(arg1Value, 2)) {
                    this.exclude_ = exclude |= 3;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = this.do2(arg0Value, arg1Value);
                    return n;
                }
                if (arg0Value.supportsUnitSize(1) && this.isDivisible(arg1Value, 1)) {
                    this.exclude_ = exclude |= 7;
                    state &= 0xFFFFFFF8;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    int n = this.do1(arg0Value, arg1Value);
                    return n;
                }
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                int n = this.doError(arg0Value, arg1Value);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ManagedMemMoveHelperNode.UnitSizeNode create() {
            return new UnitSizeNodeGen();
        }
    }
}

