/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativeVarargsAreaStackAllocationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMNativeVarargsAreaStackAllocationNode.class)
public final class LLVMNativeVarargsAreaStackAllocationNodeGen
extends LLVMNativeVarargsAreaStackAllocationNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memory_;

    private LLVMNativeVarargsAreaStackAllocationNodeGen() {
    }

    @Override
    public LLVMPointer executeWithTarget(VirtualFrame frameValue, long arg0Value) {
        int state = this.state_;
        if (state != 0) {
            return this.alloc(frameValue, arg0Value, this.memory_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMNativePointer executeAndSpecialize(VirtualFrame frameValue, long arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            this.memory_ = LLVMNode.getLLVMMemory();
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            LLVMNativePointer lLVMNativePointer = this.alloc(frameValue, arg0Value, this.memory_);
            return lLVMNativePointer;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMNativeVarargsAreaStackAllocationNode create() {
        return new LLVMNativeVarargsAreaStackAllocationNodeGen();
    }
}

