/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeFields(value={@NodeField(type=int.class, name="size"), @NodeField(type=int.class, name="alignment"), @NodeField(type=Type.class, name="symbolType")})
public abstract class LLVMGetStackSpaceInstruction
extends LLVMExpressionNode {
    @CompilerDirectives.CompilationFinal
    private FrameSlot stackPointer;

    abstract int getSize();

    abstract int getAlignment();

    abstract Type getSymbolType();

    protected FrameSlot getStackPointerSlot() {
        if (this.stackPointer == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.stackPointer = this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
        }
        return this.stackPointer;
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMAllocaInstruction
    extends LLVMGetStackSpaceInstruction {
        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame, int nr, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return LLVMNativePointer.create(LLVMStack.allocateStackMemory(frame, memory, this.getStackPointerSlot(), (long)this.getSize() * (long)nr, this.getAlignment()));
        }

        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame, long nr, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return LLVMNativePointer.create(LLVMStack.allocateStackMemory(frame, memory, this.getStackPointerSlot(), (long)this.getSize() * nr, this.getAlignment()));
        }
    }

    @NodeField(type=LLVMStack.UniquesRegion.UniqueSlot.class, name="uniqueSlot")
    public static abstract class LLVMGetUniqueStackSpaceInstruction
    extends LLVMGetStackForConstInstruction {
        abstract LLVMStack.UniquesRegion.UniqueSlot getUniqueSlot();

        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame) {
            return LLVMNativePointer.create(this.getUniqueSlot().toPointer(frame, this.getStackPointerSlot()));
        }
    }

    public static abstract class LLVMAllocaConstInstruction
    extends LLVMGetStackForConstInstruction {
        @Specialization
        protected LLVMNativePointer doOp(VirtualFrame frame, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            return LLVMNativePointer.create(LLVMStack.allocateStackMemory(frame, memory, this.getStackPointerSlot(), this.getSize(), this.getAlignment()));
        }
    }

    public static abstract class LLVMGetStackForConstInstruction
    extends LLVMGetStackSpaceInstruction {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private Type[] types = null;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private int[] offsets = null;

        public void setTypes(Type[] types) {
            this.types = types;
        }

        public void setOffsets(int[] offsets) {
            this.offsets = offsets;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public int[] getOffsets() {
            return this.offsets;
        }

        public int getLength() {
            return this.offsets.length;
        }
    }
}

