/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugDeclarationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToDebugDeclarationNode.class)
public final class LLVMToDebugDeclarationNodeGen
extends LLVMToDebugDeclarationNode {
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private FromNative0Data fromNative0_cache;

    private LLVMToDebugDeclarationNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public LLVMDebugValue executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0xE) != 0) {
            if ((state & 2) != 0) {
                FromNative0Data s2_ = this.fromNative0_cache;
                while (s2_ != null) {
                    if (s2_.llvmNative_.accepts(arg0Value) && s2_.llvmNative_.isPointer(arg0Value)) {
                        return this.fromNative(arg0Value, s2_.llvmNative_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value)) {
                        LLVMDebugValue lLVMDebugValue = this.fromNative(arg0Value, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                        return lLVMDebugValue;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((state & 8) != 0 && LLVMToDebugDeclarationNodeGen.fallbackGuard_(state, arg0Value)) {
                return this.fromGenericObject(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMDebugValue executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            LLVMDebugValue lLVMDebugValue;
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMDebugValue lLVMDebugValue2 = this.fromPointer(arg0Value_);
                return lLVMDebugValue2;
            }
            if (exclude == 0) {
                LLVMNativeLibrary llvmNative__;
                int count2_ = 0;
                FromNative0Data s2_ = this.fromNative0_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || s2_.llvmNative_.accepts(arg0Value) && s2_.llvmNative_.isPointer(arg0Value))) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (llvmNative__ = (LLVMNativeLibrary)super.insert((Node)L_L_V_M_NATIVE_LIBRARY_.create(arg0Value))).isPointer(arg0Value) && count2_ < 3) {
                    s2_ = (FromNative0Data)super.insert((Node)new FromNative0Data(this.fromNative0_cache));
                    s2_.llvmNative_ = s2_.insertAccessor(llvmNative__);
                    this.fromNative0_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    lLVMDebugValue = this.fromNative(arg0Value, s2_.llvmNative_);
                    return lLVMDebugValue;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                LLVMNativeLibrary fromNative1_llvmNative__ = (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value);
                if (fromNative1_llvmNative__.isPointer(arg0Value)) {
                    this.exclude_ = exclude |= 1;
                    this.fromNative0_cache = null;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    lLVMDebugValue = this.fromNative(arg0Value, fromNative1_llvmNative__);
                    return lLVMDebugValue;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            LLVMDebugValue lLVMDebugValue3 = this.fromGenericObject(arg0Value);
            return lLVMDebugValue3;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        FromNative0Data s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.fromNative0_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        if ((state & 1) == 0 && LLVMTypes.isPointer(arg0Value)) {
            return false;
        }
        return (state & 4) != 0 || !((LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value)).isPointer(arg0Value);
    }

    public static LLVMToDebugDeclarationNode create() {
        return new LLVMToDebugDeclarationNodeGen();
    }

    @GeneratedBy(value=LLVMToDebugDeclarationNode.class)
    private static final class FromNative0Data
    extends Node {
        @Node.Child
        FromNative0Data next_;
        @Node.Child
        LLVMNativeLibrary llvmNative_;

        FromNative0Data(FromNative0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

