/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;

final class LLDBBoxedPrimitive
implements LLVMDebugValue {
    private final Object boxedValue;

    LLDBBoxedPrimitive(Object boxedValue) {
        this.boxedValue = boxedValue;
    }

    private LLVMDebugValue unbox() {
        LLVMDebugValue.Builder builder = LLVMLanguage.getLLDBSupport().createDebugValueBuilder();
        return builder.build(this.boxedValue);
    }

    private static boolean isMatchingSize(Object value, long bitSize) {
        if (value instanceof Boolean && bitSize != 1L) {
            return false;
        }
        if (value instanceof Byte && bitSize != 8L) {
            return false;
        }
        if (value instanceof Short && bitSize != 16L) {
            return false;
        }
        if (value instanceof Integer && bitSize != 32L) {
            return false;
        }
        if (value instanceof Long && bitSize != 64L) {
            return false;
        }
        if (value instanceof Float && bitSize != 32L) {
            return false;
        }
        return !(value instanceof Double) || bitSize == 64L;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String describeValue(long bitOffset, int bitSize) {
        if (bitOffset == 0L && LLDBBoxedPrimitive.isMatchingSize(this.boxedValue, bitSize)) {
            return "<boxed value: " + this.boxedValue + ">";
        }
        if (bitSize == 1) {
            return "<bit at offset " + LLDBSupport.toSizeString(bitOffset) + " in boxed value: " + this.boxedValue + ">";
        }
        return "<" + LLDBSupport.toSizeString(bitSize) + " at offset " + LLDBSupport.toSizeString(bitOffset) + " in boxed value: " + this.boxedValue + ">";
    }

    @Override
    public boolean canRead(long bitOffset, int bits) {
        return true;
    }

    @Override
    public Object readBoolean(long bitOffset) {
        return this.unbox().readBoolean(bitOffset);
    }

    @Override
    public Object readFloat(long bitOffset) {
        return this.unbox().readFloat(bitOffset);
    }

    @Override
    public Object readDouble(long bitOffset) {
        return this.unbox().readDouble(bitOffset);
    }

    @Override
    public Object read80BitFloat(long bitOffset) {
        return this.unbox().read80BitFloat(bitOffset);
    }

    @Override
    public Object readAddress(long bitOffset) {
        if (bitOffset == 0L) {
            return "<boxed value: " + this.boxedValue + ">";
        }
        return "<offset " + LLDBSupport.toSizeString(bitOffset) + " in boxed value: " + this.boxedValue + ">";
    }

    @Override
    public Object readUnknown(long bitOffset, int bitSize) {
        return this.unbox().readUnknown(bitOffset, bitSize);
    }

    @Override
    public Object computeAddress(long bitOffset) {
        return this.readAddress(bitOffset);
    }

    @Override
    public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
        return this.unbox().readBigInteger(bitOffset, bitSize, signed);
    }

    @Override
    public LLVMDebugValue dereferencePointer(long bitOffset) {
        return bitOffset == 0L ? this.unbox() : null;
    }

    @Override
    public boolean isInteropValue() {
        return false;
    }

    @Override
    public Object asInteropValue() {
        return null;
    }
}

