/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;

public final class LLVMComplexFloatDiv
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode aNode;
    @Node.Child
    private LLVMExpressionNode bNode;
    @Node.Child
    private LLVMExpressionNode cNode;
    @Node.Child
    private LLVMExpressionNode dNode;

    public LLVMComplexFloatDiv(LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.aNode = a;
        this.bNode = b;
        this.cNode = c;
        this.dNode = d;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            float a = this.aNode.executeFloat(frame);
            float b = this.bNode.executeFloat(frame);
            float c = this.cNode.executeFloat(frame);
            float d = this.dNode.executeFloat(frame);
            float denom = c * c + d * d;
            float zReal = (a * c + b * d) / denom;
            float zImag = (b * c - a * d) / denom;
            float[] values = new float[]{zReal, zImag};
            return LLVMFloatVector.create(values);
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

