/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMPolyglotAsTyped;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotAsTyped.class)
public final class LLVMPolyglotAsTypedNodeGen
extends LLVMPolyglotAsTyped {
    @Node.Child
    private LLVMExpressionNode ptr_;
    @Node.Child
    private LLVMExpressionNode typeid_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private LLVMAsForeignNode asTyped_asForeign_;

    private LLVMPolyglotAsTypedNodeGen(LLVMExpressionNode ptr, LLVMExpressionNode typeid) {
        this.ptr_ = ptr;
        this.typeid_ = typeid;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        LLVMPointer ptrValue__;
        int state = this.state_;
        Object ptrValue_ = this.ptr_.executeGeneric(frameValue);
        Object typeidValue_ = this.typeid_.executeGeneric(frameValue);
        if ((state & 1) != 0 && LLVMTypes.isManagedPointer(ptrValue_)) {
            ptrValue__ = LLVMTypes.asManagedPointer(ptrValue_);
            if (typeidValue_ instanceof LLVMInteropType.Structured) {
                LLVMInteropType.Structured typeidValue__ = (LLVMInteropType.Structured)typeidValue_;
                return this.doAsTyped((LLVMManagedPointer)ptrValue__, typeidValue__, this.asTyped_asForeign_);
            }
        }
        if ((state & 2) != 0 && LLVMTypes.isPointer(ptrValue_)) {
            ptrValue__ = LLVMTypes.asPointer(ptrValue_);
            if (typeidValue_ instanceof LLVMInteropType.Value) {
                LLVMInteropType.Value typeidValue__ = (LLVMInteropType.Value)typeidValue_;
                return this.doError(ptrValue__, typeidValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(ptrValue_, typeidValue_);
    }

    private LLVMManagedPointer executeAndSpecialize(Object ptrValue, Object typeidValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMPointer ptrValue_;
            if (LLVMTypes.isManagedPointer(ptrValue)) {
                ptrValue_ = LLVMTypes.asManagedPointer(ptrValue);
                if (typeidValue instanceof LLVMInteropType.Structured) {
                    LLVMInteropType.Structured typeidValue_ = (LLVMInteropType.Structured)typeidValue;
                    this.asTyped_asForeign_ = (LLVMAsForeignNode)super.insert((Node)LLVMAsForeignNode.create());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedPointer lLVMManagedPointer = this.doAsTyped((LLVMManagedPointer)ptrValue_, typeidValue_, this.asTyped_asForeign_);
                    return lLVMManagedPointer;
                }
            }
            if (LLVMTypes.isPointer(ptrValue)) {
                ptrValue_ = LLVMTypes.asPointer(ptrValue);
                if (typeidValue instanceof LLVMInteropType.Value) {
                    LLVMInteropType.Value typeidValue_ = (LLVMInteropType.Value)typeidValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedPointer lLVMManagedPointer = this.doError(ptrValue_, typeidValue_);
                    return lLVMManagedPointer;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.ptr_, this.typeid_}, new Object[]{ptrValue, typeidValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LLVMPolyglotAsTyped create(LLVMExpressionNode ptr, LLVMExpressionNode typeid) {
        return new LLVMPolyglotAsTypedNodeGen(ptr, typeid);
    }
}

