/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMPolyglotAsTypedNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="ptr", type=LLVMExpressionNode.class), @NodeChild(value="typeid", type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotAsTyped
extends LLVMIntrinsic {
    public static LLVMPolyglotAsTyped create(LLVMExpressionNode ptr, LLVMExpressionNode typeid) {
        return LLVMPolyglotAsTypedNodeGen.create(ptr, typeid);
    }

    @Specialization
    LLVMManagedPointer doAsTyped(LLVMManagedPointer object, LLVMInteropType.Structured type, @Cached(value="create()") LLVMAsForeignNode asForeign) {
        Object foreign = asForeign.execute(object);
        return LLVMManagedPointer.create(LLVMTypedForeignObject.create(foreign, type));
    }

    @Specialization
    LLVMManagedPointer doError(LLVMPointer object, LLVMInteropType.Value type) {
        CompilerDirectives.transferToInterpreter();
        throw new LLVMPolyglotException((Node)this, "polyglot_as_typed can not be used with primitive type (%s).", new Object[]{type.getKind()});
    }
}

