/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMArrayTypeIDNode;

@GeneratedBy(value=LLVMArrayTypeIDNode.class)
public final class LLVMArrayTypeIDNodeGen
extends LLVMArrayTypeIDNode {
    @Node.Child
    private LLVMExpressionNode base_;
    @Node.Child
    private LLVMExpressionNode len_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private LLVMArrayTypeIDNodeGen(LLVMExpressionNode base, LLVMExpressionNode len) {
        this.base_ = base;
        this.len_ = len;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.executeGeneric_long0(frameValue, state);
        }
        return this.executeGeneric_generic1(frameValue, state);
    }

    private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
        long lenValue_;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        try {
            lenValue_ = this.len_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(baseValue_, ex.getResult());
        }
        assert ((state & 1) != 0);
        if (baseValue_ instanceof LLVMInteropType) {
            LLVMInteropType baseValue__ = (LLVMInteropType)baseValue_;
            if (lenValue_ >= 0L) {
                return this.doArray(baseValue__, lenValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, lenValue_);
    }

    private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        Object lenValue_ = this.len_.executeGeneric(frameValue);
        if ((state & 1) != 0 && baseValue_ instanceof LLVMInteropType) {
            long lenValue__;
            LLVMInteropType baseValue__ = (LLVMInteropType)baseValue_;
            if (lenValue_ instanceof Long && (lenValue__ = ((Long)lenValue_).longValue()) >= 0L) {
                return this.doArray(baseValue__, lenValue__);
            }
        }
        if ((state & 2) != 0 && LLVMArrayTypeIDNodeGen.fallbackGuard_(baseValue_, lenValue_)) {
            return this.doError(baseValue_, lenValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, lenValue_);
    }

    private Object executeAndSpecialize(Object baseValue, Object lenValue) {
        int state = this.state_;
        if (baseValue instanceof LLVMInteropType) {
            long lenValue_;
            LLVMInteropType baseValue_ = (LLVMInteropType)baseValue;
            if (lenValue instanceof Long && (lenValue_ = ((Long)lenValue).longValue()) >= 0L) {
                this.state_ = state |= 1;
                return this.doArray(baseValue_, lenValue_);
            }
        }
        this.state_ = state |= 2;
        return this.doError(baseValue, lenValue);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(Object baseValue, Object lenValue) {
        long lenValue_;
        return !(baseValue instanceof LLVMInteropType) || !(lenValue instanceof Long) || (lenValue_ = ((Long)lenValue).longValue()) < 0L;
    }

    public static LLVMArrayTypeIDNode create(LLVMExpressionNode base, LLVMExpressionNode len) {
        return new LLVMArrayTypeIDNodeGen(base, len);
    }
}

