/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleWriteManagedToGlobal;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTruffleWriteManagedToGlobal.class)
public final class LLVMTruffleWriteManagedToGlobalNodeGen
extends LLVMTruffleWriteManagedToGlobal {
    @Node.Child
    private LLVMExpressionNode child0_;
    @Node.Child
    private LLVMExpressionNode child1_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;

    private LLVMTruffleWriteManagedToGlobalNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        Object child1Value_ = this.child1_.executeGeneric(frameValue);
        if (state != 0 && LLVMTypes.isPointer(child0Value_)) {
            LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
            return this.write(child0Value__, child1Value_, (LLVMContext)this.lLVMLanguageContextReference_.get());
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_, child1Value_);
    }

    private Object executeAndSpecialize(Object child0Value, Object child1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (LLVMTypes.isPointer(child0Value)) {
                LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
                TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__ == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                }
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.write(child0Value_, child1Value, (LLVMContext)lLVMLanguageContextReference__.get());
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_, this.child1_}, new Object[]{child0Value, child1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMTruffleWriteManagedToGlobal create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMTruffleWriteManagedToGlobalNodeGen(child0, child1);
    }
}

