/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
public abstract class LLVMTruffleWriteManagedToGlobal
extends LLVMIntrinsic {
    @Node.Child
    LLVMReadNode.AttachInteropTypeNode attachType = LLVMReadNodeFactory.AttachInteropTypeNodeGen.create();

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected Object write(LLVMPointer address, Object value, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
        LLVMGlobal global = ctx.findGlobal(address);
        if (global == null) {
            throw new LLVMPolyglotException(this, "First argument to truffle_assign_managed must be a pointer to a global.");
        }
        Object newValue = this.attachType.execute(value, global.getInteropType());
        global.setTarget(newValue);
        return newValue;
    }
}

