/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleManagedToHandle;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMTruffleManagedToHandle.class)
public final class LLVMTruffleManagedToHandleNodeGen
extends LLVMTruffleManagedToHandle {
    @Node.Child
    private LLVMExpressionNode child0_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory memory_;

    private LLVMTruffleManagedToHandleNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (state != 0 && LLVMTypes.isManagedPointer(child0Value_)) {
            LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
            return this.doIntrinsic(child0Value__, (LLVMContext)this.lLVMLanguageContextReference_.get(), this.memory_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(child0Value_);
    }

    private LLVMNativePointer executeAndSpecialize(Object child0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (LLVMTypes.isManagedPointer(child0Value)) {
                LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
                TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__ == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                }
                this.memory_ = LLVMNode.getLLVMMemory();
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMNativePointer lLVMNativePointer = this.doIntrinsic(child0Value_, (LLVMContext)lLVMLanguageContextReference__.get(), this.memory_);
                return lLVMNativePointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.child0_}, new Object[]{child0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMTruffleManagedToHandle create(LLVMExpressionNode child0) {
        return new LLVMTruffleManagedToHandleNodeGen(child0);
    }
}

