/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMReadStringNode.class)
public final class LLVMReadStringNodeGen
extends LLVMReadStringNode {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private LLVMReadStringNode.ForeignReadStringNode readForeign_read_;

    private LLVMReadStringNodeGen() {
    }

    @Override
    public String executeWithTarget(Object arg0Value) {
        LLVMManagedPointer arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof String) {
            String arg0Value_2 = (String)arg0Value;
            return this.readString(arg0Value_2);
        }
        if ((state & 2) != 0 && LLVMTypes.isManagedPointer(arg0Value) && LLVMReadStringNode.isForeign(arg0Value_ = LLVMTypes.asManagedPointer(arg0Value))) {
            return this.readForeign(arg0Value_, this.readForeign_read_);
        }
        if ((state & 4) != 0 && LLVMReadStringNodeGen.fallbackGuard_(state, arg0Value)) {
            return this.readOther(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            LLVMManagedPointer arg0Value_;
            if (arg0Value instanceof String) {
                String arg0Value_2 = (String)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.readString(arg0Value_2);
                return string;
            }
            if (LLVMTypes.isManagedPointer(arg0Value) && LLVMReadStringNode.isForeign(arg0Value_ = LLVMTypes.asManagedPointer(arg0Value))) {
                this.readForeign_read_ = (LLVMReadStringNode.ForeignReadStringNode)super.insert((Node)LLVMReadStringNode.ForeignReadStringNode.create());
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.readForeign(arg0Value_, this.readForeign_read_);
                return string;
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            String string = this.readOther(arg0Value);
            return string;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        LLVMManagedPointer arg0Value_;
        if ((state & 1) == 0 && arg0Value instanceof String) {
            return false;
        }
        return !LLVMTypes.isManagedPointer(arg0Value) || !LLVMReadStringNode.isForeign(arg0Value_ = LLVMTypes.asManagedPointer(arg0Value));
    }

    public static LLVMReadStringNode create() {
        return new LLVMReadStringNodeGen();
    }

    @GeneratedBy(value=LLVMReadStringNode.PointerReadStringNode.class)
    static final class PointerReadStringNodeGen
    extends LLVMReadStringNode.PointerReadStringNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedPointerData cachedPointer_cache;

        private PointerReadStringNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected String execute(Object arg0Value) {
            int state = this.state_;
            if (state != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                if ((state & 1) != 0) {
                    CachedPointerData s1_ = this.cachedPointer_cache;
                    while (s1_ != null) {
                        if (s1_.cachedAddress_.equals(arg0Value_)) {
                            assert (this.isReadOnlyMemory(s1_.cachedAddress_));
                            return this.doCachedPointer(arg0Value_, s1_.cachedAddress_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doReadString(arg0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    if (exclude == 0) {
                        LLVMPointer cachedAddress__;
                        int count1_ = 0;
                        CachedPointerData s1_ = this.cachedPointer_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null) {
                                if (s1_.cachedAddress_.equals(arg0Value_)) {
                                    assert (this.isReadOnlyMemory(s1_.cachedAddress_));
                                    break;
                                }
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && this.isReadOnlyMemory(cachedAddress__ = arg0Value_) && count1_ < 3) {
                            s1_ = new CachedPointerData(this.cachedPointer_cache);
                            s1_.cachedAddress_ = cachedAddress__;
                            s1_.result_ = this.doReadString(cachedAddress__);
                            this.cachedPointer_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            String string = this.doCachedPointer(arg0Value_, s1_.cachedAddress_, s1_.result_);
                            return string;
                        }
                    }
                    this.exclude_ = exclude |= 1;
                    this.cachedPointer_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    String string = this.doReadString(arg0Value_);
                    return string;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedPointerData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cachedPointer_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMReadStringNode.PointerReadStringNode create() {
            return new PointerReadStringNodeGen();
        }

        @GeneratedBy(value=LLVMReadStringNode.PointerReadStringNode.class)
        private static final class CachedPointerData {
            @CompilerDirectives.CompilationFinal
            CachedPointerData next_;
            @CompilerDirectives.CompilationFinal
            LLVMPointer cachedAddress_;
            @CompilerDirectives.CompilationFinal
            String result_;

            CachedPointerData(CachedPointerData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
    static final class ForeignReadStringNodeGen
    extends LLVMReadStringNode.ForeignReadStringNode {
        @Node.Child
        private LLVMReadStringNode.Dummy object_;
        @Node.Child
        private LLVMAsForeignNode foreign_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private Default0Data default0_cache;
        @Node.Child
        private LLVMReadStringNode.PointerReadStringNode default1_read_;

        private ForeignReadStringNodeGen(LLVMReadStringNode.Dummy object, LLVMAsForeignNode foreign) {
            this.object_ = object;
            this.foreign_ = foreign;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected String execute(LLVMManagedPointer objectValue) {
            int state = this.state_;
            Object foreignValue_ = this.foreign_.execute(objectValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    Default0Data s1_ = this.default0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(foreignValue_)) {
                            return this.doDefault(objectValue, foreignValue_, s1_.interop_, s1_.read_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.default1Boundary(state, objectValue, foreignValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(objectValue, foreignValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private String default1Boundary(int state, LLVMManagedPointer objectValue, Object foreignValue_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                String string = this.doDefault(objectValue, foreignValue_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(foreignValue_), this.default1_read_);
                return string;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(LLVMManagedPointer objectValue, Object foreignValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                String string;
                if (exclude == 0) {
                    int count1_ = 0;
                    Default0Data s1_ = this.default0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(foreignValue)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (Default0Data)super.insert((Node)new Default0Data(this.default0_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(foreignValue));
                        s1_.read_ = s1_.insertAccessor(LLVMReadStringNode.PointerReadStringNode.create());
                        this.default0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        String string2 = this.doDefault(objectValue, foreignValue, s1_.interop_, s1_.read_);
                        return string2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.default1_read_ = (LLVMReadStringNode.PointerReadStringNode)super.insert((Node)LLVMReadStringNode.PointerReadStringNode.create());
                    this.exclude_ = exclude |= 1;
                    this.default0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    string = this.doDefault(objectValue, foreignValue, (InteropLibrary)INTEROP_LIBRARY_.getUncached(foreignValue), this.default1_read_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            Default0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.default0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMReadStringNode.ForeignReadStringNode create(LLVMReadStringNode.Dummy object, LLVMAsForeignNode foreign) {
            return new ForeignReadStringNodeGen(object, foreign);
        }

        @GeneratedBy(value=LLVMReadStringNode.ForeignReadStringNode.class)
        private static final class Default0Data
        extends Node {
            @Node.Child
            Default0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @Node.Child
            LLVMReadStringNode.PointerReadStringNode read_;

            Default0Data(Default0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

