/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMReadStringNode
extends LLVMNode {
    @Node.Child
    PointerReadStringNode readOther;

    public abstract String executeWithTarget(Object var1);

    @Specialization
    String readString(String address) {
        return address;
    }

    @Specialization(guards={"isForeign(foreign)"})
    String readForeign(LLVMManagedPointer foreign, @Cached(value="create()") ForeignReadStringNode read) {
        return read.execute(foreign);
    }

    @Fallback
    String readOther(Object address) {
        if (this.readOther == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readOther = (PointerReadStringNode)this.insert(PointerReadStringNode.create());
        }
        return this.readOther.execute(address);
    }

    protected static boolean isForeign(LLVMManagedPointer pointer) {
        return pointer.getOffset() == 0L && pointer.getObject() instanceof LLVMTypedForeignObject;
    }

    static abstract class PointerReadStringNode
    extends LLVMNode {
        @Node.Child
        private LLVMGetElementPtrNode.LLVMIncrementPointerNode inc = LLVMGetElementPtrNodeGen.LLVMIncrementPointerNodeGen.create();
        @Node.Child
        private LLVMLoadNode read = LLVMI8LoadNodeGen.create(null);

        PointerReadStringNode() {
        }

        protected abstract String execute(Object var1);

        boolean isReadOnlyMemory(LLVMPointer address) {
            CompilerAsserts.neverPartOfCompilation();
            LLVMGlobal global = ((LLVMContext)this.lookupContextReference(LLVMLanguage.class).get()).findGlobal(address);
            if (global != null) {
                return global.isReadOnly();
            }
            return false;
        }

        @Specialization(guards={"cachedAddress.equals(address)", "isReadOnlyMemory(cachedAddress)"})
        String doCachedPointer(LLVMPointer address, @Cached(value="address") LLVMPointer cachedAddress, @Cached(value="doReadString(cachedAddress)") String result) {
            return result;
        }

        @Specialization(replaces={"doCachedPointer"})
        String doReadString(LLVMPointer address) {
            LLVMPointer ptr = address;
            int length = 0;
            while ((Byte)this.read.executeWithTarget(ptr) != 0) {
                ++length;
                ptr = this.inc.executeWithTarget(ptr, 1);
            }
            char[] string = new char[length];
            ptr = address;
            for (int i = 0; i < length; ++i) {
                string[i] = (char)Byte.toUnsignedInt((Byte)this.read.executeWithTarget(ptr));
                ptr = this.inc.executeWithTarget(ptr, 1);
            }
            return PointerReadStringNode.toString(string);
        }

        @CompilerDirectives.TruffleBoundary
        private static String toString(char[] string) {
            return new String(string);
        }

        public static PointerReadStringNode create() {
            return LLVMReadStringNodeGen.PointerReadStringNodeGen.create();
        }
    }

    @NodeChildren(value={@NodeChild(value="object", type=Dummy.class), @NodeChild(value="foreign", type=LLVMAsForeignNode.class, executeWith={"object"})})
    static abstract class ForeignReadStringNode
    extends LLVMNode {
        ForeignReadStringNode() {
        }

        protected abstract String execute(LLVMManagedPointer var1);

        @Specialization(limit="3")
        String doDefault(LLVMManagedPointer object, Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached PointerReadStringNode read) {
            if (interop.isString(foreign)) {
                try {
                    return interop.asString(foreign);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return read.execute(object);
        }

        public static ForeignReadStringNode create() {
            return LLVMReadStringNodeGen.ForeignReadStringNodeGen.create(null, LLVMAsForeignNode.createOptional());
        }
    }

    static abstract class Dummy
    extends LLVMNode {
        Dummy() {
        }

        protected abstract LLVMManagedPointer execute();
    }
}

