/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadCharsetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMGetElementPtrNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteBuffer;

@NodeChildren(value={@NodeChild(value="object", type=LLVMExpressionNode.class), @NodeChild(value="buffer", type=LLVMExpressionNode.class), @NodeChild(value="buflen", type=LLVMExpressionNode.class), @NodeChild(value="charset", type=LLVMReadCharsetNode.class)})
public abstract class LLVMPolyglotAsString
extends LLVMIntrinsic {
    @Node.Child
    EncodeStringNode encodeString = LLVMPolyglotAsStringNodeGen.EncodeStringNodeGen.create();
    @Node.Child
    WriteStringNode writeString = LLVMPolyglotAsStringNodeGen.WriteStringNodeGen.create();

    public static LLVMPolyglotAsString create(LLVMExpressionNode object, LLVMExpressionNode buffer, LLVMExpressionNode buflen, LLVMExpressionNode charset) {
        return LLVMPolyglotAsStringNodeGen.create(object, buffer, buflen, LLVMReadCharsetNodeGen.create(charset));
    }

    @Specialization
    long doAsString(VirtualFrame frame, Object object, Object buffer, long buflen, LLVMReadCharsetNode.LLVMCharset charset) {
        ByteBuffer result = this.encodeString.execute(object, charset);
        return this.writeString.execute(frame, result, buffer, buflen, charset.zeroTerminatorLen);
    }

    static abstract class WriteStringNode
    extends LLVMNode {
        @Node.Child
        private LLVMGetElementPtrNode.LLVMIncrementPointerNode inc = LLVMGetElementPtrNodeGen.LLVMIncrementPointerNodeGen.create();
        @Node.Child
        private LLVMStoreNode write = LLVMI8StoreNodeGen.create(null, null);

        WriteStringNode() {
        }

        protected abstract long execute(VirtualFrame var1, ByteBuffer var2, Object var3, long var4, int var6);

        @Specialization(guards={"srcBuffer.getClass() == srcBufferClass"})
        long doWrite(ByteBuffer srcBuffer, LLVMPointer target, long targetLen, int zeroTerminatorLen, @Cached(value="srcBuffer.getClass()") Class<? extends ByteBuffer> srcBufferClass) {
            long bytesWritten;
            ByteBuffer source = (ByteBuffer)CompilerDirectives.castExact((Object)srcBuffer, srcBufferClass);
            LLVMPointer ptr = target;
            for (bytesWritten = 0L; source.hasRemaining() && bytesWritten < targetLen; ++bytesWritten) {
                this.write.executeWithTarget(ptr, source.get());
                ptr = this.inc.executeWithTarget(ptr, 1);
            }
            long ret = bytesWritten;
            for (int i = 0; i < zeroTerminatorLen && bytesWritten < targetLen; ++bytesWritten, ++i) {
                this.write.executeWithTarget(ptr, (byte)0);
                ptr = this.inc.executeWithTarget(ptr, 1);
            }
            return ret;
        }
    }

    static abstract class BoxedEncodeStringNode
    extends LLVMNode {
        BoxedEncodeStringNode() {
        }

        abstract ByteBuffer execute(Object var1, LLVMReadCharsetNode.LLVMCharset var2);

        @Specialization(limit="3")
        ByteBuffer doBoxed(Object object, LLVMReadCharsetNode.LLVMCharset charset, @CachedLibrary(value="object") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                String unboxed = interop.asString(object);
                return charset.encode(unboxed);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Polyglot value is not a string.");
            }
        }
    }

    static abstract class EncodeStringNode
    extends LLVMNode {
        EncodeStringNode() {
        }

        protected abstract ByteBuffer execute(Object var1, LLVMReadCharsetNode.LLVMCharset var2);

        @Specialization
        ByteBuffer doString(String str, LLVMReadCharsetNode.LLVMCharset charset) {
            return charset.encode(str);
        }

        @Specialization
        ByteBuffer doForeign(LLVMManagedPointer obj, LLVMReadCharsetNode.LLVMCharset charset, @Cached LLVMAsForeignNode asForeign, @Cached BoxedEncodeStringNode encode) {
            return encode.execute(asForeign.execute(obj), charset);
        }
    }
}

