/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsPrimitive;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMPolyglotAsPrimitive.class)
public final class LLVMPolyglotAsPrimitiveFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsDouble.class)
    public static final class AsDoubleNodeGen
    extends LLVMPolyglotAsPrimitive.AsDouble {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsDouble0Data asDouble0_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asDouble1_exception_;

        private AsDoubleNodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsDouble0Data s1_ = this.asDouble0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asDouble(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asDouble1Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asDouble1Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Double d = this.asDouble(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asDouble1_exception_);
                return d;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public double executeDouble(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsDouble0Data s1_ = this.asDouble0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asDouble(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asDouble1Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private double asDouble1Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                double d = this.asDouble(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asDouble1_exception_);
                return d;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                double d;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsDouble0Data s1_ = this.asDouble0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsDouble0Data)super.insert((Node)new AsDouble0Data(this.asDouble0_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asDouble0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        double d2 = this.asDouble(child0Value, s1_.interop_, s1_.exception_);
                        return d2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asDouble1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asDouble0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    d = this.asDouble(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asDouble1_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return d;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsDouble0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asDouble0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsDouble create(LLVMAsForeignNode child0) {
            return new AsDoubleNodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsDouble.class)
        private static final class AsDouble0Data
        extends Node {
            @Node.Child
            AsDouble0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsDouble0Data(AsDouble0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsFloat.class)
    public static final class AsFloatNodeGen
    extends LLVMPolyglotAsPrimitive.AsFloat {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsFloat0Data asFloat0_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asFloat1_exception_;

        private AsFloatNodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsFloat0Data s1_ = this.asFloat0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return Float.valueOf(this.asFloat(child0Value_, s1_.interop_, s1_.exception_));
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asFloat1Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(child0Value_));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asFloat1Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Float f = Float.valueOf(this.asFloat(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asFloat1_exception_));
                return f;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public float executeFloat(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsFloat0Data s1_ = this.asFloat0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asFloat(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asFloat1Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private float asFloat1Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                float f = this.asFloat(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asFloat1_exception_);
                return f;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                float f;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsFloat0Data s1_ = this.asFloat0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsFloat0Data)super.insert((Node)new AsFloat0Data(this.asFloat0_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asFloat0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        float f2 = this.asFloat(child0Value, s1_.interop_, s1_.exception_);
                        return f2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asFloat1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asFloat0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    f = this.asFloat(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asFloat1_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return f;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsFloat0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asFloat0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsFloat create(LLVMAsForeignNode child0) {
            return new AsFloatNodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsFloat.class)
        private static final class AsFloat0Data
        extends Node {
            @Node.Child
            AsFloat0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsFloat0Data(AsFloat0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI64.class)
    public static final class AsI64NodeGen
    extends LLVMPolyglotAsPrimitive.AsI64 {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsI640Data asI640_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asI641_exception_;

        private AsI64NodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI640Data s1_ = this.asI640_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI64(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI641Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asI641Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = this.asI64(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI641_exception_);
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public long executeI64(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI640Data s1_ = this.asI640_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI64(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI641Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private long asI641Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                long l = this.asI64(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI641_exception_);
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                long l;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsI640Data s1_ = this.asI640_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsI640Data)super.insert((Node)new AsI640Data(this.asI640_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asI640_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l2 = this.asI64(child0Value, s1_.interop_, s1_.exception_);
                        return l2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asI641_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asI640_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    l = this.asI64(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asI641_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return l;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsI640Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asI640_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsI64 create(LLVMAsForeignNode child0) {
            return new AsI64NodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI64.class)
        private static final class AsI640Data
        extends Node {
            @Node.Child
            AsI640Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsI640Data(AsI640Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI32.class)
    public static final class AsI32NodeGen
    extends LLVMPolyglotAsPrimitive.AsI32 {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsI320Data asI320_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asI321_exception_;

        private AsI32NodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI320Data s1_ = this.asI320_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI32(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI321Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asI321Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Integer n = this.asI32(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI321_exception_);
                return n;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public int executeI32(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI320Data s1_ = this.asI320_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI32(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI321Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private int asI321Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                int n = this.asI32(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI321_exception_);
                return n;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                int n;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsI320Data s1_ = this.asI320_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsI320Data)super.insert((Node)new AsI320Data(this.asI320_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asI320_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        int n2 = this.asI32(child0Value, s1_.interop_, s1_.exception_);
                        return n2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asI321_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asI320_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    n = this.asI32(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asI321_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsI320Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asI320_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsI32 create(LLVMAsForeignNode child0) {
            return new AsI32NodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI32.class)
        private static final class AsI320Data
        extends Node {
            @Node.Child
            AsI320Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsI320Data(AsI320Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI16.class)
    public static final class AsI16NodeGen
    extends LLVMPolyglotAsPrimitive.AsI16 {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsI160Data asI160_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asI161_exception_;

        private AsI16NodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI160Data s1_ = this.asI160_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI16(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI161Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asI161Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Short s = this.asI16(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI161_exception_);
                return s;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public short executeI16(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI160Data s1_ = this.asI160_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI16(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI161Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private short asI161Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                short s = this.asI16(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI161_exception_);
                return s;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                short s;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsI160Data s1_ = this.asI160_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsI160Data)super.insert((Node)new AsI160Data(this.asI160_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asI160_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        short s2 = this.asI16(child0Value, s1_.interop_, s1_.exception_);
                        return s2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asI161_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asI160_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    s = this.asI16(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asI161_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return s;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsI160Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asI160_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsI16 create(LLVMAsForeignNode child0) {
            return new AsI16NodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI16.class)
        private static final class AsI160Data
        extends Node {
            @Node.Child
            AsI160Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsI160Data(AsI160Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI8.class)
    public static final class AsI8NodeGen
    extends LLVMPolyglotAsPrimitive.AsI8 {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsI80Data asI80_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asI81_exception_;

        private AsI8NodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI80Data s1_ = this.asI80_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI8(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI81Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asI81Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Byte by = this.asI8(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI81_exception_);
                return by;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public byte executeI8(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsI80Data s1_ = this.asI80_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asI8(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asI81Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private byte asI81Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                byte by = this.asI8(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asI81_exception_);
                return by;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                byte by;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsI80Data s1_ = this.asI80_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsI80Data)super.insert((Node)new AsI80Data(this.asI80_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asI80_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        byte by2 = this.asI8(child0Value, s1_.interop_, s1_.exception_);
                        return by2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asI81_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asI80_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    by = this.asI8(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asI81_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return by;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsI80Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asI80_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsI8 create(LLVMAsForeignNode child0) {
            return new AsI8NodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsI8.class)
        private static final class AsI80Data
        extends Node {
            @Node.Child
            AsI80Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsI80Data(AsI80Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsBoolean.class)
    public static final class AsBooleanNodeGen
    extends LLVMPolyglotAsPrimitive.AsBoolean {
        @Node.Child
        private LLVMAsForeignNode child0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private AsBoolean0Data asBoolean0_cache;
        @CompilerDirectives.CompilationFinal
        private BranchProfile asBoolean1_exception_;

        private AsBooleanNodeGen(LLVMAsForeignNode child0) {
            this.child0_ = child0;
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsBoolean0Data s1_ = this.asBoolean0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asBoolean(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asBoolean1Boundary(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object asBoolean1Boundary(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Boolean bl = this.asBoolean(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asBoolean1_exception_);
                return bl;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public boolean executeI1(VirtualFrame frameValue) {
            int state = this.state_;
            Object child0Value_ = this.child0_.execute(frameValue);
            if (state != 0) {
                if ((state & 1) != 0) {
                    AsBoolean0Data s1_ = this.asBoolean0_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(child0Value_)) {
                            return this.asBoolean(child0Value_, s1_.interop_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.asBoolean1Boundary0(state, child0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(child0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private boolean asBoolean1Boundary0(int state, Object child0Value_) {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                boolean bl = this.asBoolean(child0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value_), this.asBoolean1_exception_);
                return bl;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object child0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                boolean bl;
                if (exclude == 0) {
                    int count1_ = 0;
                    AsBoolean0Data s1_ = this.asBoolean0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.interop_.accepts(child0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (AsBoolean0Data)super.insert((Node)new AsBoolean0Data(this.asBoolean0_cache));
                        s1_.interop_ = (InteropLibrary)s1_.insertAccessor(INTEROP_LIBRARY_.create(child0Value));
                        s1_.exception_ = BranchProfile.create();
                        this.asBoolean0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl2 = this.asBoolean(child0Value, s1_.interop_, s1_.exception_);
                        return bl2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.asBoolean1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.asBoolean0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    bl = this.asBoolean(child0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(child0Value), this.asBoolean1_exception_);
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            AsBoolean0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.asBoolean0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMPolyglotAsPrimitive.AsBoolean create(LLVMAsForeignNode child0) {
            return new AsBooleanNodeGen(child0);
        }

        @GeneratedBy(value=LLVMPolyglotAsPrimitive.AsBoolean.class)
        private static final class AsBoolean0Data
        extends Node {
            @Node.Child
            AsBoolean0Data next_;
            @Node.Child
            InteropLibrary interop_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;

            AsBoolean0Data(AsBoolean0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

