/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsPrimitiveFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;

@NodeChild(type=LLVMAsForeignNode.class)
public abstract class LLVMPolyglotAsPrimitive
extends LLVMIntrinsic {

    public static abstract class AsDouble
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsDoubleNodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        double asDouble(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asDouble(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_double can not be convented to double.");
            }
        }
    }

    public static abstract class AsFloat
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsFloatNodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        float asFloat(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asFloat(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_float can not be convented to float.");
            }
        }
    }

    public static abstract class AsI64
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI64NodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        long asI64(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asLong(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i64 can not be convented to i64.");
            }
        }
    }

    public static abstract class AsI32
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI32NodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        int asI32(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asInt(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i32 can not be convented to i32.");
            }
        }
    }

    public static abstract class AsI16
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI16NodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        short asI16(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asShort(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i16 can not be convented to i16.");
            }
        }
    }

    public static abstract class AsI8
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsI8NodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        byte asI8(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asByte(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_i8 can not be convented to i8.");
            }
        }
    }

    public static abstract class AsBoolean
    extends LLVMPolyglotAsPrimitive {
        public static LLVMPolyglotAsPrimitive create(LLVMExpressionNode arg) {
            return LLVMPolyglotAsPrimitiveFactory.AsBooleanNodeGen.create(LLVMAsForeignNode.create(arg));
        }

        @Specialization(limit="3")
        boolean asBoolean(Object foreign, @CachedLibrary(value="foreign") InteropLibrary interop, @Cached BranchProfile exception) {
            try {
                return interop.asBoolean(foreign);
            }
            catch (UnsupportedMessageException ex) {
                exception.enter();
                throw new LLVMPolyglotException(this, "Argument to polyglot_as_boolean can not be convented to boolean.");
            }
        }
    }
}

