/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSignal;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMSignal.class)
public final class LLVMSignalNodeGen
extends LLVMSignal {
    @Node.Child
    private LLVMExpressionNode signal_;
    @Node.Child
    private LLVMExpressionNode handler_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
    @Node.Child
    private LLVMToNativeNode toNative_;

    private LLVMSignalNodeGen(LLVMExpressionNode signal, LLVMExpressionNode handler) {
        this.signal_ = signal;
        this.handler_ = handler;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int signalValue_;
        int state = this.state_;
        try {
            signalValue_ = this.signal_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object handlerValue = this.handler_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), handlerValue);
        }
        Object handlerValue_ = this.handler_.executeGeneric(frameValue);
        if (state != 0) {
            return this.doSignal(signalValue_, handlerValue_, (LLVMContext)this.lLVMLanguageContextReference_.get(), this.toNative_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(signalValue_, handlerValue_);
    }

    private LLVMPointer executeAndSpecialize(Object signalValue, Object handlerValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (signalValue instanceof Integer) {
                int signalValue_ = (Integer)signalValue;
                TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                if (lLVMLanguageContextReference__ == null) {
                    this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                }
                this.toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.doSignal(signalValue_, handlerValue, (LLVMContext)lLVMLanguageContextReference__.get(), this.toNative_);
                return lLVMPointer;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.signal_, this.handler_}, new Object[]{signalValue, handlerValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMSignal create(LLVMExpressionNode signal, LLVMExpressionNode handler) {
        return new LLVMSignalNodeGen(signal, handler);
    }
}

