/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMString;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMProcessStat;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LLVMInfo {
    private static final int UTS_FIELD_LENGTH = 65;
    public static final String SYSNAME = System.getProperty("os.name");
    public static final String RELEASE = System.getProperty("os.version");
    public static final String MACHINE;

    private static String readFile(String name, String fallback) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Path path = Paths.get(name, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                return new String(Files.readAllBytes(path)).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    @CompilerDirectives.TruffleBoundary
    public static String getHostname() {
        String hostname = LLVMInfo.readFile("/proc/sys/kernel/hostname", null);
        if (hostname != null) {
            return hostname;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static String getVersion() {
        return LLVMInfo.readFile("/proc/sys/kernel/version", null);
    }

    @CompilerDirectives.TruffleBoundary
    public static String getDomainName() {
        return LLVMInfo.readFile("/proc/sys/kernel/domainname", null);
    }

    public static long uname(LLVMMemory memory, LLVMNativePointer name) {
        LLVMNativePointer ptr = name;
        LLVMString.strcpy(memory, ptr, SYSNAME);
        ptr = ptr.increment(65L);
        LLVMString.strcpy(memory, ptr, LLVMInfo.getHostname());
        ptr = ptr.increment(65L);
        LLVMString.strcpy(memory, ptr, RELEASE);
        ptr = ptr.increment(65L);
        LLVMString.strcpy(memory, ptr, LLVMInfo.getVersion());
        ptr = ptr.increment(65L);
        LLVMString.strcpy(memory, ptr, MACHINE);
        ptr = ptr.increment(65L);
        LLVMString.strcpy(memory, ptr, LLVMInfo.getDomainName());
        return 0L;
    }

    @CompilerDirectives.TruffleBoundary
    private static LLVMProcessStat getstat() {
        String stat = LLVMInfo.readFile("/proc/self/stat", null);
        if (stat == null) {
            return null;
        }
        return new LLVMProcessStat(stat);
    }

    @CompilerDirectives.TruffleBoundary
    public static long getpid() {
        LLVMProcessStat stat = LLVMInfo.getstat();
        if (stat != null) {
            return stat.getPid();
        }
        String info = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(info.split("@")[0]);
    }

    @CompilerDirectives.TruffleBoundary
    public static long getppid() {
        LLVMProcessStat stat = LLVMInfo.getstat();
        if (stat != null) {
            return stat.getPpid();
        }
        return 1L;
    }

    static {
        String arch = System.getProperty("os.arch");
        if ("amd64".equals(arch)) {
            arch = "x86_64";
        }
        MACHINE = arch;
    }
}

