/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64ToI8Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64ToI8Node.class)
public final class LLVMAMD64ToI8NodeFactory {

    @GeneratedBy(value=LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node.class)
    public static final class LLVMAMD64I64ToI8NodeGen
    extends LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private ForeignToLLVM managedPointer_toLLVM_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;

        private LLVMAMD64I64ToI8NodeGen(int shift, LLVMExpressionNode fromNode) {
            super(shift);
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 3) == 0 && state != 0) {
                return this.executeGeneric_long0(frameValue, state);
            }
            return this.executeGeneric_generic1(frameValue, state);
        }

        private Object executeGeneric_long0(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_generic1(VirtualFrame frameValue, int state) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_) && this.isForeign((LLVMManagedPointer)(fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_)))) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, this.managedPointer_toLLVM_);
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__2 = (Long)fromNodeValue_;
                return this.doI8(fromNodeValue__2);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 3) == 0 && state != 0) {
                return this.executeI8_long2(frameValue, state);
            }
            return this.executeI8_generic3(frameValue, state);
        }

        private byte executeI8_long2(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI8(fromNodeValue_);
        }

        private byte executeI8_generic3(VirtualFrame frameValue, int state) {
            LLVMPointer fromNodeValue__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_) && this.isForeign((LLVMManagedPointer)(fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_)))) {
                return this.doManagedPointer((LLVMManagedPointer)fromNodeValue__, this.managedPointer_toLLVM_);
            }
            if ((state & 2) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__2 = (Long)fromNodeValue_;
                return this.doI8(fromNodeValue__2);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private byte executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                LLVMPointer fromNodeValue_;
                if (LLVMTypes.isManagedPointer(fromNodeValue) && this.isForeign((LLVMManagedPointer)(fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue)))) {
                    this.managedPointer_toLLVM_ = (ForeignToLLVM)super.insert((Node)this.createForeignToLLVM());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    byte by = this.doManagedPointer((LLVMManagedPointer)fromNodeValue_, this.managedPointer_toLLVM_);
                    return by;
                }
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    byte by = this.doPointer(fromNodeValue_, this.pointer_toNative_);
                    return by;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_2 = (Long)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    byte by = this.doI8(fromNodeValue_2);
                    return by;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64ToI8Node.LLVMAMD64I64ToI8Node create(int shift, LLVMExpressionNode fromNode) {
            return new LLVMAMD64I64ToI8NodeGen(shift, fromNode);
        }
    }
}

