/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64PushNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64PushNode.class)
public final class LLVMAMD64PushNodeFactory {

    @GeneratedBy(value=LLVMAMD64PushNode.LLVMAMD64PushqNode.class)
    public static final class LLVMAMD64PushqNodeGen
    extends LLVMAMD64PushNode.LLVMAMD64PushqNode {
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private FrameSlot slot_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAMD64PushqNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            long valueValue_;
            int state = this.state_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doVoid(frameValue, valueValue_, this.slot_, this.memory_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (valueValue instanceof Long) {
                    long valueValue_ = (Long)valueValue;
                    this.slot_ = this.getStackPointerSlot();
                    this.memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doVoid(frameValue, valueValue_, this.slot_, this.memory_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.value_}, new Object[]{valueValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64PushNode.LLVMAMD64PushqNode create(LLVMExpressionNode value) {
            return new LLVMAMD64PushqNodeGen(value);
        }
    }

    @GeneratedBy(value=LLVMAMD64PushNode.LLVMAMD64PushlNode.class)
    public static final class LLVMAMD64PushlNodeGen
    extends LLVMAMD64PushNode.LLVMAMD64PushlNode {
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private FrameSlot slot_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAMD64PushlNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int valueValue_;
            int state = this.state_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doVoid(frameValue, valueValue_, this.slot_, this.memory_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (valueValue instanceof Integer) {
                    int valueValue_ = (Integer)valueValue;
                    this.slot_ = this.getStackPointerSlot();
                    this.memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doVoid(frameValue, valueValue_, this.slot_, this.memory_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.value_}, new Object[]{valueValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64PushNode.LLVMAMD64PushlNode create(LLVMExpressionNode value) {
            return new LLVMAMD64PushlNodeGen(value);
        }
    }

    @GeneratedBy(value=LLVMAMD64PushNode.LLVMAMD64PushwNode.class)
    public static final class LLVMAMD64PushwNodeGen
    extends LLVMAMD64PushNode.LLVMAMD64PushwNode {
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private FrameSlot slot_;
        @CompilerDirectives.CompilationFinal
        private LLVMMemory memory_;

        private LLVMAMD64PushwNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short valueValue_;
            int state = this.state_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doVoid(frameValue, valueValue_, this.slot_, this.memory_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, valueValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object valueValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (valueValue instanceof Short) {
                    short valueValue_ = (Short)valueValue;
                    this.slot_ = this.getStackPointerSlot();
                    this.memory_ = LLVMNode.getLLVMMemory();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.doVoid(frameValue, valueValue_, this.slot_, this.memory_);
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.value_}, new Object[]{valueValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64PushNode.LLVMAMD64PushwNode create(LLVMExpressionNode value) {
            return new LLVMAMD64PushwNodeGen(value);
        }
    }
}

