/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;

public abstract class LLVMAMD64PopNode
extends LLVMExpressionNode {
    protected FrameSlot getStackPointerSlot() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getRootNode().getFrameDescriptor().findFrameSlot((Object)"<stackpointer>");
    }

    public static abstract class LLVMAMD64PopqNode
    extends LLVMAMD64PopNode {
        @Specialization
        protected long doI64(VirtualFrame frame, @Cached(value="getStackPointerSlot()") FrameSlot slot, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            LLVMStack.StackPointer basePointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot);
            long sp = basePointer.get(memory);
            long value = memory.getI64(sp);
            basePointer.set(sp += 8L);
            return value;
        }
    }

    public static abstract class LLVMAMD64PoplNode
    extends LLVMAMD64PopNode {
        @Specialization
        protected int doI32(VirtualFrame frame, @Cached(value="getStackPointerSlot()") FrameSlot slot, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            LLVMStack.StackPointer basePointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot);
            long sp = basePointer.get(memory);
            int value = memory.getI32(sp);
            basePointer.set(sp += 4L);
            return value;
        }
    }

    public static abstract class LLVMAMD64PopwNode
    extends LLVMAMD64PopNode {
        @Specialization
        protected short doI16(VirtualFrame frame, @Cached(value="getStackPointerSlot()") FrameSlot slot, @Cached(value="getLLVMMemory()") LLVMMemory memory) {
            LLVMStack.StackPointer basePointer = (LLVMStack.StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)slot);
            long sp = basePointer.get(memory);
            short value = memory.getI16(sp);
            basePointer.set(sp += 2L);
            return value;
        }
    }
}

