/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;

public final class LLVMNodeSourceDescriptor {
    private static final SourceSection DEFAULT_SOURCE_SECTION;
    private LLVMSourceLocation sourceLocation;
    private boolean hasStatementTag;

    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public SourceSection getSourceSection() {
        if (this.sourceLocation == null) {
            return DEFAULT_SOURCE_SECTION;
        }
        return this.sourceLocation.getSourceSection();
    }

    public boolean hasStatementTag() {
        return this.hasStatementTag && this.sourceLocation != null;
    }

    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        CompilerAsserts.neverPartOfCompilation();
        this.sourceLocation = sourceLocation;
    }

    public void setHasStatementTag(boolean hasStatementTag) {
        CompilerAsserts.neverPartOfCompilation();
        this.hasStatementTag = hasStatementTag;
    }

    static {
        Source source = Source.newBuilder((String)"llvm", (CharSequence)"LLVM IR", (String)"<llvm ir>").mimeType("text/plain").build();
        DEFAULT_SOURCE_SECTION = source.createUnavailableSection();
    }
}

