/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
final class VirtualAllocGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);

    private VirtualAllocGen() {
    }

    static {
        LibraryExport.register(LLVMManagedAccessDefaults.VirtualAlloc.class, (LibraryExport[])new LibraryExport[]{new LLVMManagedReadLibraryExports(), new LLVMManagedWriteLibraryExports()});
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
    private static final class LLVMManagedWriteLibraryExports
    extends LibraryExport<LLVMManagedWriteLibrary> {
        private LLVMManagedWriteLibraryExports() {
            super(LLVMManagedWriteLibrary.class, int[].class, true);
        }

        protected LLVMManagedWriteLibrary createUncached(Object receiver) {
            assert (receiver instanceof int[]);
            return new Uncached();
        }

        protected LLVMManagedWriteLibrary createCached(Object receiver) {
            assert (receiver instanceof int[]);
            return new Cached();
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        private static final class Uncached
        extends LLVMManagedWriteLibrary {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof int[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof int[];
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                if (arg2Value instanceof Long) {
                    long arg2Value_ = (Long)arg2Value;
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                if (arg2Value instanceof LLVMPointer) {
                    LLVMPointer arg2Value_ = (LLVMPointer)arg2Value;
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)arg2Value_), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isWritable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((int[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                LLVMManagedAccessDefaults.VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        private static final class Cached
        extends LLVMManagedWriteLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;
            @Node.Child
            private WriteGenericI64WritePointer0Data writeGenericI64_writePointer0_cache;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof int[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof int[];
            }

            @Override
            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            public void writeGenericI64(Object arg0Value_, long arg1Value, Object arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 7) != 0) {
                    if ((state & 1) != 0 && arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                        return;
                    }
                    if ((state & 6) != 0 && arg2Value instanceof LLVMPointer) {
                        LLVMPointer arg2Value_ = (LLVMPointer)arg2Value;
                        if ((state & 2) != 0) {
                            WriteGenericI64WritePointer0Data s2_ = this.writeGenericI64_writePointer0_cache;
                            while (s2_ != null) {
                                if (s2_.nativeLib_.accepts(arg2Value_)) {
                                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, s2_.nativeLib_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                                    return;
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state & 4) != 0) {
                            this.writePointer1Boundary(state, arg0Value, arg1Value, arg2Value_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericI64AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private void writePointer1Boundary(int state, int[] arg0Value, long arg1Value, LLVMPointer arg2Value_) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)arg2Value_), (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeGenericI64AndSpecialize(int[] arg0Value, long arg1Value, Object arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (arg2Value instanceof Long) {
                        long arg2Value_ = (Long)arg2Value;
                        TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                        if (lLVMLanguageReference__ == null) {
                            this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                        }
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writeI64(arg0Value, arg1Value, arg2Value_, (LLVMLanguage)lLVMLanguageReference__.get());
                        return;
                    }
                    if (arg2Value instanceof LLVMPointer) {
                        LLVMPointer arg2Value_ = (LLVMPointer)arg2Value;
                        if (exclude == 0) {
                            int count2_ = 0;
                            WriteGenericI64WritePointer0Data s2_ = this.writeGenericI64_writePointer0_cache;
                            if ((state & 2) != 0) {
                                while (s2_ != null && !s2_.nativeLib_.accepts(arg2Value_)) {
                                    s2_ = s2_.next_;
                                    ++count2_;
                                }
                            }
                            if (s2_ == null && count2_ < 3) {
                                s2_ = (WriteGenericI64WritePointer0Data)super.insert((Node)new WriteGenericI64WritePointer0Data(this.writeGenericI64_writePointer0_cache));
                                s2_.nativeLib_ = (LLVMNativeLibrary)s2_.insertAccessor(L_L_V_M_NATIVE_LIBRARY_.create((Object)arg2Value_));
                                TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                                if (lLVMLanguageReference__ == null) {
                                    this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                                }
                                this.writeGenericI64_writePointer0_cache = s2_;
                                this.state_ = state |= 2;
                            }
                            if (s2_ != null) {
                                lock.unlock();
                                hasLock = false;
                                LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, s2_.nativeLib_, (LLVMLanguage)this.lLVMLanguageReference_.get());
                                return;
                            }
                        }
                        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                        try {
                            TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                            if (lLVMLanguageReference__ == null) {
                                this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                            }
                            this.exclude_ = exclude |= 1;
                            this.writeGenericI64_writePointer0_cache = null;
                            state &= 0xFFFFFFFD;
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            LLVMManagedAccessDefaults.VirtualAlloc.WriteGenericI64.writePointer(arg0Value, arg1Value, arg2Value_, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached((Object)arg2Value_), (LLVMLanguage)lLVMLanguageReference__.get());
                            return;
                        }
                        finally {
                            NodeUtil.popEncapsulatingNode((Node)prev_);
                        }
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                WriteGenericI64WritePointer0Data s2_;
                int state = this.state_;
                if ((state & 7) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 7 & (state & 7) - 1) == 0 && ((s2_ = this.writeGenericI64_writePointer0_cache) == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public boolean isWritable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((int[])receiver);
            }

            @Override
            public void writeI8(Object arg0Value_, long arg1Value, byte arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI8Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI8Node_AndSpecialize(int[] arg0Value, long arg1Value, byte arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI8(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI16(Object arg0Value_, long arg1Value, short arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI16Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI16Node_AndSpecialize(int[] arg0Value, long arg1Value, short arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI16(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI32(Object arg0Value_, long arg1Value, int arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI32Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI32Node_AndSpecialize(int[] arg0Value, long arg1Value, int arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI32(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeI64(Object arg0Value_, long arg1Value, long arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeI64Node_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeI64Node_AndSpecialize(int[] arg0Value, long arg1Value, long arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeI64(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeFloat(Object arg0Value_, long arg1Value, float arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x80) != 0) {
                    LLVMManagedAccessDefaults.VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeFloatNode_AndSpecialize(int[] arg0Value, long arg1Value, float arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeFloat(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeDouble(Object arg0Value_, long arg1Value, double arg2Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x100) != 0) {
                    LLVMManagedAccessDefaults.VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeDoubleNode_AndSpecialize(int[] arg0Value, long arg1Value, double arg2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    LLVMManagedAccessDefaults.VirtualAlloc.writeDouble(arg0Value, arg1Value, arg2Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
            private static final class WriteGenericI64WritePointer0Data
            extends Node {
                @Node.Child
                WriteGenericI64WritePointer0Data next_;
                @Node.Child
                LLVMNativeLibrary nativeLib_;

                WriteGenericI64WritePointer0Data(WriteGenericI64WritePointer0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }

    @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
    private static final class LLVMManagedReadLibraryExports
    extends LibraryExport<LLVMManagedReadLibrary> {
        private LLVMManagedReadLibraryExports() {
            super(LLVMManagedReadLibrary.class, int[].class, true);
        }

        protected LLVMManagedReadLibrary createUncached(Object receiver) {
            assert (receiver instanceof int[]);
            return new Uncached();
        }

        protected LLVMManagedReadLibrary createCached(Object receiver) {
            assert (receiver instanceof int[]);
            return new Cached();
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        private static final class Uncached
        extends LLVMManagedReadLibrary {
            private final TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_ = this.lookupLanguageReference(LLVMLanguage.class);

            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof int[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof int[];
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((int[])receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI8(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI16(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI32(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readI64(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readFloat(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readDouble(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                return LLVMManagedAccessDefaults.VirtualAlloc.readPointer(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
            }
        }

        @GeneratedBy(value=LLVMManagedAccessDefaults.VirtualAlloc.class)
        private static final class Cached
        extends LLVMManagedReadLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<LLVMLanguage> lLVMLanguageReference_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof int[]) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults.VirtualAlloc'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof int[];
            }

            @Override
            public boolean isReadable(Object receiver) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return LLVMManagedAccessDefaults.VirtualAlloc.isAccessible((int[])receiver);
            }

            @Override
            public byte readI8(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 1) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI8(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI8Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte readI8Node_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    byte by = LLVMManagedAccessDefaults.VirtualAlloc.readI8(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return by;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state = this.state_;
                if ((state & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public short readI16(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 2) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI16(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI16Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private short readI16Node_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    short s = LLVMManagedAccessDefaults.VirtualAlloc.readI16(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return s;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int readI32(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 4) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI32(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI32Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int readI32Node_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    int n = LLVMManagedAccessDefaults.VirtualAlloc.readI32(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return n;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readGenericI64(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 8) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readI64(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readI64Node_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long readI64Node_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    long l = LLVMManagedAccessDefaults.VirtualAlloc.readI64(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return l;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float readFloat(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x10) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readFloat(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private float readFloatNode_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    float f = LLVMManagedAccessDefaults.VirtualAlloc.readFloat(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return f;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double readDouble(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x20) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readDouble(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private double readDoubleNode_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    double d = LLVMManagedAccessDefaults.VirtualAlloc.readDouble(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return d;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LLVMPointer readPointer(Object arg0Value_, long arg1Value) {
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                int[] arg0Value = (int[])arg0Value_;
                int state = this.state_;
                if ((state & 0x40) != 0) {
                    return LLVMManagedAccessDefaults.VirtualAlloc.readPointer(arg0Value, arg1Value, (LLVMLanguage)this.lLVMLanguageReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readPointerNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LLVMPointer readPointerNode_AndSpecialize(int[] arg0Value, long arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                try {
                    TruffleLanguage.LanguageReference lLVMLanguageReference__ = this.lLVMLanguageReference_;
                    if (lLVMLanguageReference__ == null) {
                        this.lLVMLanguageReference_ = lLVMLanguageReference__ = super.lookupLanguageReference(LLVMLanguage.class);
                    }
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = LLVMManagedAccessDefaults.VirtualAlloc.readPointer(arg0Value, arg1Value, (LLVMLanguage)lLVMLanguageReference__.get());
                    return lLVMPointer;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

