/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedAccessDefaults;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMManagedWriteLibrary.class)
final class LLVMManagedWriteLibraryGen
extends LibraryFactory<LLVMManagedWriteLibrary> {
    private static final Class<LLVMManagedWriteLibrary> LIBRARY_CLASS = LLVMManagedWriteLibraryGen.lazyLibraryClass();
    private static final Message IS_WRITABLE = new MessageImpl("isWritable", 0, Boolean.TYPE, Object.class);
    private static final Message WRITE_I8 = new MessageImpl("writeI8", 1, Void.TYPE, Object.class, Long.TYPE, Byte.TYPE);
    private static final Message WRITE_I16 = new MessageImpl("writeI16", 2, Void.TYPE, Object.class, Long.TYPE, Short.TYPE);
    private static final Message WRITE_I32 = new MessageImpl("writeI32", 3, Void.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    private static final Message WRITE_FLOAT = new MessageImpl("writeFloat", 4, Void.TYPE, Object.class, Long.TYPE, Float.TYPE);
    private static final Message WRITE_I64 = new MessageImpl("writeI64", 5, Void.TYPE, Object.class, Long.TYPE, Long.TYPE);
    private static final Message WRITE_GENERIC_I64 = new MessageImpl("writeGenericI64", 6, Void.TYPE, Object.class, Long.TYPE, Object.class);
    private static final Message WRITE_DOUBLE = new MessageImpl("writeDouble", 7, Void.TYPE, Object.class, Long.TYPE, Double.TYPE);
    private static final Message WRITE_POINTER = new MessageImpl("writePointer", 8, Void.TYPE, Object.class, Long.TYPE, LLVMPointer.class);
    private static final LLVMManagedWriteLibraryGen INSTANCE = new LLVMManagedWriteLibraryGen();

    private LLVMManagedWriteLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(IS_WRITABLE, WRITE_I8, WRITE_I16, WRITE_I32, WRITE_FLOAT, WRITE_I64, WRITE_GENERIC_I64, WRITE_DOUBLE, WRITE_POINTER)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof int[]) {
            return LLVMManagedAccessDefaults.VirtualAlloc.class;
        }
        return LLVMManagedAccessDefaults.FallbackWrite.class;
    }

    protected LLVMManagedWriteLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMManagedWriteLibrary lib = (LLVMManagedWriteLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.isWritable(receiver);
            }
            case 1: {
                lib.writeI8(receiver, (Long)args[offset], (Byte)args[offset + 1]);
                return null;
            }
            case 2: {
                lib.writeI16(receiver, (Long)args[offset], (Short)args[offset + 1]);
                return null;
            }
            case 3: {
                lib.writeI32(receiver, (Long)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 4: {
                lib.writeFloat(receiver, (Long)args[offset], ((Float)args[offset + 1]).floatValue());
                return null;
            }
            case 5: {
                lib.writeI64(receiver, (Long)args[offset], (Long)args[offset + 1]);
                return null;
            }
            case 6: {
                lib.writeGenericI64(receiver, (Long)args[offset], args[offset + 1]);
                return null;
            }
            case 7: {
                lib.writeDouble(receiver, (Long)args[offset], (Double)args[offset + 1]);
                return null;
            }
            case 8: {
                lib.writePointer(receiver, (Long)args[offset], (LLVMPointer)args[offset + 1]);
                return null;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMManagedWriteLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMManagedWriteLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMManagedWriteLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary", false, LLVMManagedWriteLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMManagedWriteLibrary {
        @Node.Child
        LLVMManagedWriteLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMManagedWriteLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public boolean isWritable(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isWritable(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeI8(Object receiver_, long offset, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeI8(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeI16(Object receiver_, long offset, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeI16(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeI32(Object receiver_, long offset, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeI32(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeFloat(Object receiver_, long offset, float value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeFloat(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeI64(Object receiver_, long offset, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeI64(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeGenericI64(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writeDouble(Object receiver_, long offset, double value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeDouble(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMManagedWriteLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writePointer(receiver_, offset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            LLVMManagedWriteLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (LLVMManagedWriteLibrary)this.insert((Node)INSTANCE.create(receiver_));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        LLVMManagedWriteLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMManagedWriteLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMManagedWriteLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(LLVMManagedWriteLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMManagedWriteLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw new AssertionError();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static final class UncachedDispatch
    extends LLVMManagedWriteLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isWritable(Object receiver_) {
            return ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).isWritable(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI8(Object receiver_, long offset, byte value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI8(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI16(Object receiver_, long offset, short value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI16(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI32(Object receiver_, long offset, int value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI32(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFloat(Object receiver_, long offset, float value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeFloat(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI64(Object receiver_, long offset, long value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI64(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeGenericI64(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeDouble(Object receiver_, long offset, double value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeDouble(receiver_, offset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writePointer(receiver_, offset, value);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMManagedWriteLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isWritable(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                boolean bl = ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).isWritable(receiver_);
                return bl;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI8(Object receiver_, long offset, byte value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI8(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI16(Object receiver_, long offset, short value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI16(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI32(Object receiver_, long offset, int value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI32(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFloat(Object receiver_, long offset, float value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeFloat(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeI64(Object receiver_, long offset, long value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeI64(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeGenericI64(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeDouble(Object receiver_, long offset, double value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writeDouble(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((LLVMManagedWriteLibrary)INSTANCE.getUncached(receiver_)).writePointer(receiver_, offset, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static final class Proxy
    extends LLVMManagedWriteLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isWritable(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_WRITABLE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeI8(Object receiver_, long offset, byte value) {
            try {
                this.lib.send(receiver_, WRITE_I8, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeI16(Object receiver_, long offset, short value) {
            try {
                this.lib.send(receiver_, WRITE_I16, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeI32(Object receiver_, long offset, int value) {
            try {
                this.lib.send(receiver_, WRITE_I32, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeFloat(Object receiver_, long offset, float value) {
            try {
                this.lib.send(receiver_, WRITE_FLOAT, new Object[]{offset, Float.valueOf(value)});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeI64(Object receiver_, long offset, long value) {
            try {
                this.lib.send(receiver_, WRITE_I64, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeGenericI64(Object receiver_, long offset, Object value) {
            try {
                this.lib.send(receiver_, WRITE_GENERIC_I64, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writeDouble(Object receiver_, long offset, double value) {
            try {
                this.lib.send(receiver_, WRITE_DOUBLE, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public void writePointer(Object receiver_, long offset, LLVMPointer value) {
            try {
                this.lib.send(receiver_, WRITE_POINTER, new Object[]{offset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMManagedWriteLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }
}

