/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMGetStackNode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeConvertNode;
import com.oracle.truffle.llvm.runtime.interop.nfi.LLVMNativeWrapper;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMNativeWrapper.class)
public final class LLVMNativeWrapperFactory {

    @GeneratedBy(value=LLVMNativeWrapper.CallbackHelperNode.class)
    static final class CallbackHelperNodeGen
    extends LLVMNativeWrapper.CallbackHelperNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> lLVMLanguageContextReference_;
        @Node.Child
        private CachedData cached_cache;

        private CallbackHelperNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        Object execute(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value == s1_.cachedFunction_) {
                            return this.doCached(arg0Value, arg1Value, s1_.cachedFunction_, s1_.getStack_, this.lLVMLanguageContextReference_, s1_.call_, s1_.convertArgs_, s1_.convertRet_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.doGeneric(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg0Value != s1_.cachedFunction_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (CachedData)super.insert((Node)new CachedData(this.cached_cache));
                        s1_.cachedFunction_ = arg0Value;
                        s1_.getStack_ = s1_.insertAccessor(LLVMGetStackNode.create());
                        TruffleLanguage.ContextReference lLVMLanguageContextReference__ = this.lLVMLanguageContextReference_;
                        if (lLVMLanguageContextReference__ == null) {
                            this.lLVMLanguageContextReference_ = lLVMLanguageContextReference__ = super.lookupContextReference(LLVMLanguage.class);
                        }
                        s1_.call_ = s1_.insertAccessor(this.createCallNode(s1_.cachedFunction_));
                        s1_.convertArgs_ = s1_.insertAccessor(LLVMNativeWrapper.CallbackHelperNode.createFromNativeNodes(s1_.cachedFunction_.getType()));
                        s1_.convertRet_ = s1_.insertAccessor(LLVMNativeConvertNode.createToNative(s1_.cachedFunction_.getType().getReturnType()));
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doCached(arg0Value, arg1Value, s1_.cachedFunction_, s1_.getStack_, this.lLVMLanguageContextReference_, s1_.call_, s1_.convertArgs_, s1_.convertRet_);
                        return object;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arg0Value, arg1Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMNativeWrapper.CallbackHelperNode create() {
            return new CallbackHelperNodeGen();
        }

        public static LLVMNativeWrapper.CallbackHelperNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=LLVMNativeWrapper.CallbackHelperNode.class)
        private static final class Uncached
        extends LLVMNativeWrapper.CallbackHelperNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                return this.doGeneric(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=LLVMNativeWrapper.CallbackHelperNode.class)
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            LLVMFunctionDescriptor cachedFunction_;
            @Node.Child
            LLVMGetStackNode getStack_;
            @Node.Child
            DirectCallNode call_;
            @Node.Children
            LLVMNativeConvertNode[] convertArgs_;
            @Node.Child
            LLVMNativeConvertNode convertRet_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

