/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetIndexPointerNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMForeignGetIndexPointerNode.class)
public final class LLVMForeignGetIndexPointerNodeGen
extends LLVMForeignGetIndexPointerNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;
    @CompilerDirectives.CompilationFinal
    private BranchProfile generic_exception_;

    private LLVMForeignGetIndexPointerNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public LLVMPointer execute(LLVMInteropType arg0Value, LLVMPointer arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
        int state = this.state_;
        if (state != 0) {
            if ((state & 3) != 0 && arg0Value instanceof LLVMInteropType.Array) {
                LLVMInteropType.Array arg0Value_ = (LLVMInteropType.Array)arg0Value;
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (arg0Value_.getElementType() == s1_.elementType_) {
                            return LLVMForeignGetIndexPointerNode.doCached(arg0Value_, arg1Value, arg2Value, s1_.elementSize_, s1_.elementType_, s1_.exception_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return LLVMForeignGetIndexPointerNode.doGeneric(arg0Value_, arg1Value, arg2Value, this.generic_exception_);
                }
            }
            if ((state & 4) != 0 && LLVMForeignGetIndexPointerNodeGen.fallbackGuard_(state, arg0Value, arg1Value, arg2Value)) {
                return LLVMForeignGetIndexPointerNode.doError(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LLVMPointer executeAndSpecialize(LLVMInteropType arg0Value, LLVMPointer arg1Value, long arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof LLVMInteropType.Array) {
                LLVMInteropType.Array arg0Value_ = (LLVMInteropType.Array)arg0Value;
                if (exclude == 0) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && arg0Value_.getElementType() != s1_.elementType_) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        LLVMInteropType elementType__ = arg0Value_.getElementType();
                        if (arg0Value_.getElementType() == elementType__ && count1_ < 3) {
                            s1_ = new CachedData(this.cached_cache);
                            s1_.elementSize_ = arg0Value_.getElementSize();
                            s1_.elementType_ = elementType__;
                            s1_.exception_ = BranchProfile.create();
                            this.cached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        LLVMPointer lLVMPointer = LLVMForeignGetIndexPointerNode.doCached(arg0Value_, arg1Value, arg2Value, s1_.elementSize_, s1_.elementType_, s1_.exception_);
                        return lLVMPointer;
                    }
                }
                this.generic_exception_ = BranchProfile.create();
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = LLVMForeignGetIndexPointerNode.doGeneric(arg0Value_, arg1Value, arg2Value, this.generic_exception_);
                return lLVMPointer;
            }
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            LLVMPointer lLVMPointer = LLVMForeignGetIndexPointerNode.doError(arg0Value, arg1Value, arg2Value);
            return lLVMPointer;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    private static boolean fallbackGuard_(int state, LLVMInteropType arg0Value, LLVMPointer arg1Value, long arg2Value) {
        return (state & 2) != 0 || !(arg0Value instanceof LLVMInteropType.Array);
    }

    public static LLVMForeignGetIndexPointerNode create() {
        return new LLVMForeignGetIndexPointerNodeGen();
    }

    public static LLVMForeignGetIndexPointerNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMForeignGetIndexPointerNode.class)
    private static final class Uncached
    extends LLVMForeignGetIndexPointerNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer execute(LLVMInteropType arg0Value, LLVMPointer arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException {
            if (arg0Value instanceof LLVMInteropType.Array) {
                LLVMInteropType.Array arg0Value_ = (LLVMInteropType.Array)arg0Value;
                return LLVMForeignGetIndexPointerNode.doGeneric(arg0Value_, arg1Value, arg2Value, BranchProfile.getUncached());
            }
            return LLVMForeignGetIndexPointerNode.doError(arg0Value, arg1Value, arg2Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=LLVMForeignGetIndexPointerNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        long elementSize_;
        @CompilerDirectives.CompilationFinal
        LLVMInteropType elementType_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

