/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(type=Dummy.class), @NodeChild(type=InteropTypeNode.class)})
public abstract class ToPointer
extends ForeignToLLVM {
    public static ToPointer create() {
        return ToPointerNodeGen.create(null, new InteropTypeNode(null));
    }

    public static ToPointer create(LLVMInteropType.Structured type) {
        return ToPointerNodeGen.create(null, new InteropTypeNode(type));
    }

    @Specialization
    protected LLVMManagedPointer fromInt(int value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromChar(char value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(Character.valueOf(value));
    }

    @Specialization
    protected LLVMManagedPointer fromLong(long value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromByte(byte value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromShort(short value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromFloat(float value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(Float.valueOf(value));
    }

    @Specialization
    protected LLVMManagedPointer fromDouble(double value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected LLVMManagedPointer fromBoolean(boolean value, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(value);
    }

    @Specialization
    protected String fromString(String obj, LLVMInteropType.Structured type) {
        return obj;
    }

    @Specialization
    protected LLVMPointer fromPointer(LLVMPointer pointer, LLVMInteropType.Structured type) {
        return pointer;
    }

    @Specialization(guards={"notLLVM(obj)"})
    protected LLVMManagedPointer fromTruffleObject(Object obj, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(LLVMTypedForeignObject.create(obj, type));
    }

    @Specialization
    protected LLVMManagedPointer fromInternal(LLVMInternalTruffleObject object, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(object);
    }

    @CompilerDirectives.TruffleBoundary
    static Object slowPathPrimitiveConvert(Object value, LLVMInteropType.Structured type) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return LLVMManagedPointer.create(value);
        }
        if (value instanceof Boolean) {
            return LLVMManagedPointer.create(value);
        }
        if (value instanceof Character) {
            return LLVMManagedPointer.create(value);
        }
        if (value instanceof String) {
            return value;
        }
        if (LLVMPointer.isInstance(value)) {
            return value;
        }
        if (value instanceof LLVMInternalTruffleObject) {
            return LLVMManagedPointer.create(value);
        }
        if (ToPointer.notLLVM(value)) {
            return LLVMManagedPointer.create(LLVMTypedForeignObject.create(value, type));
        }
        throw UnsupportedTypeException.create((Object[])new Object[]{value});
    }

    static final class InteropTypeNode
    extends LLVMNode {
        private final LLVMInteropType.Structured type;

        private InteropTypeNode(LLVMInteropType.Structured type) {
            this.type = type;
        }

        public LLVMInteropType.Structured execute() {
            return this.type;
        }
    }

    static abstract class Dummy
    extends LLVMNode {
        Dummy() {
        }

        protected abstract Object execute();
    }
}

