/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToI64.class)
public final class ToI64NodeGen
extends ToI64 {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<LLVMNativeLibrary> L_L_V_M_NATIVE_LIBRARY_ = LibraryFactory.resolve(LLVMNativeLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private FromForeign0Data fromForeign0_cache;
    @CompilerDirectives.CompilationFinal
    private BranchProfile fromForeign1_exception_;
    @Node.Child
    private FromForeignPointer0Data fromForeignPointer0_cache;

    private ToI64NodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeWithForeignToLLVMType(Object arg0Value, LLVMInteropType.Structured type, ForeignToLLVM.ForeignToLLVMType ftlType) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x3C00) != 0) {
            Node prev_;
            if ((state & 0x400) != 0) {
                FromForeign0Data s11_ = this.fromForeign0_cache;
                while (s11_ != null) {
                    if (s11_.interop_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && s11_.interop_.isNumber(arg0Value)) {
                        return this.fromForeign(arg0Value, s11_.interop_, s11_.exception_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                        Long l = this.fromForeign(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.fromForeign1_exception_);
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((state & 0x1000) != 0) {
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value) && s13_.nativeLib_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && !s13_.interop_.isNumber(arg0Value)) {
                        return this.fromForeignPointer(arg0Value, s13_.interop_, s13_.nativeLib_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                        Long l = this.fromForeignPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeWithType(Object arg0Value, LLVMInteropType.Structured type) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x3C00) != 0) {
            Node prev_;
            if ((state & 0x400) != 0) {
                FromForeign0Data s11_ = this.fromForeign0_cache;
                while (s11_ != null) {
                    if (s11_.interop_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && s11_.interop_.isNumber(arg0Value)) {
                        return this.fromForeign(arg0Value, s11_.interop_, s11_.exception_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                        Long l = this.fromForeign(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.fromForeign1_exception_);
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((state & 0x1000) != 0) {
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value) && s13_.nativeLib_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && !s13_.interop_.isNumber(arg0Value)) {
                        return this.fromForeignPointer(arg0Value, s13_.interop_, s13_.nativeLib_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                        Long l = this.fromForeignPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return this.fromChar(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return this.fromShort(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.fromLong(arg0Value_);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return this.fromByte(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return this.fromFloat(arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            return this.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.fromBoolean(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return this.fromString(arg0Value_);
        }
        if ((state & 0x200) != 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            return this.fromPointer(arg0Value_);
        }
        if ((state & 0x3C00) != 0) {
            Node prev_;
            if ((state & 0x400) != 0) {
                FromForeign0Data s11_ = this.fromForeign0_cache;
                while (s11_ != null) {
                    if (s11_.interop_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && s11_.interop_.isNumber(arg0Value)) {
                        return this.fromForeign(arg0Value, s11_.interop_, s11_.exception_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                        Long l = this.fromForeign(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.fromForeign1_exception_);
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((state & 0x1000) != 0) {
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts(arg0Value) && s13_.nativeLib_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && !s13_.interop_.isNumber(arg0Value)) {
                        return this.fromForeignPointer(arg0Value, s13_.interop_, s13_.nativeLib_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && ForeignToLLVM.notLLVM(arg0Value)) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (!((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                        Long l = this.fromForeignPointer(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            Long l;
            Object interop__;
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Long l2 = this.fromInt(arg0Value_);
                return l2;
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Long l3 = this.fromChar(arg0Value_);
                return l3;
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Long l4 = this.fromShort(arg0Value_);
                return l4;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Long l5 = this.fromLong(arg0Value_);
                return l5;
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Long l6 = this.fromByte(arg0Value_);
                return l6;
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Long l7 = this.fromFloat(arg0Value_);
                return l7;
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Long l8 = this.fromDouble(arg0Value_);
                return l8;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                Long l9 = this.fromBoolean(arg0Value_);
                return l9;
            }
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Long l10 = this.fromString(arg0Value_);
                return l10;
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                LLVMPointer lLVMPointer = this.fromPointer(arg0Value_);
                return lLVMPointer;
            }
            if ((exclude & 1) == 0) {
                int count11_ = 0;
                FromForeign0Data s11_ = this.fromForeign0_cache;
                if ((state & 0x400) != 0) {
                    while (!(s11_ == null || s11_.interop_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && s11_.interop_.isNumber(arg0Value))) {
                        s11_ = s11_.next_;
                        ++count11_;
                    }
                }
                if (s11_ == null && ForeignToLLVM.notLLVM(arg0Value) && (interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).isNumber(arg0Value) && count11_ < 5) {
                    s11_ = (FromForeign0Data)super.insert((Node)new FromForeign0Data(this.fromForeign0_cache));
                    s11_.interop_ = s11_.insertAccessor(interop__);
                    s11_.exception_ = BranchProfile.create();
                    this.fromForeign0_cache = s11_;
                    this.state_ = state |= 0x400;
                }
                if (s11_ != null) {
                    lock.unlock();
                    hasLock = false;
                    interop__ = this.fromForeign(arg0Value, s11_.interop_, s11_.exception_);
                    return interop__;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                InteropLibrary fromForeign1_interop__;
                if (ForeignToLLVM.notLLVM(arg0Value) && (fromForeign1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                    this.fromForeign1_exception_ = BranchProfile.create();
                    this.exclude_ = exclude |= 1;
                    this.fromForeign0_cache = null;
                    state &= 0xFFFFFBFF;
                    this.state_ = state |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    interop__ = this.fromForeign(arg0Value, fromForeign1_interop__, this.fromForeign1_exception_);
                    return interop__;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            if ((exclude & 2) == 0) {
                int count13_ = 0;
                FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
                if ((state & 0x1000) != 0) {
                    while (!(s13_ == null || s13_.interop_.accepts(arg0Value) && s13_.nativeLib_.accepts(arg0Value) && ForeignToLLVM.notLLVM(arg0Value) && !s13_.interop_.isNumber(arg0Value))) {
                        s13_ = s13_.next_;
                        ++count13_;
                    }
                }
                if (s13_ == null && ForeignToLLVM.notLLVM(arg0Value) && !(interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).isNumber(arg0Value) && count13_ < 5) {
                    s13_ = (FromForeignPointer0Data)super.insert((Node)new FromForeignPointer0Data(this.fromForeignPointer0_cache));
                    s13_.interop_ = s13_.insertAccessor(interop__);
                    s13_.nativeLib_ = (LLVMNativeLibrary)s13_.insertAccessor(L_L_V_M_NATIVE_LIBRARY_.create(arg0Value));
                    this.fromForeignPointer0_cache = s13_;
                    this.state_ = state |= 0x1000;
                }
                if (s13_ != null) {
                    lock.unlock();
                    hasLock = false;
                    l = this.fromForeignPointer(arg0Value, s13_.interop_, s13_.nativeLib_);
                    return l;
                }
            }
            prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                InteropLibrary fromForeignPointer1_interop__;
                if (ForeignToLLVM.notLLVM(arg0Value) && !(fromForeignPointer1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isNumber(arg0Value)) {
                    this.exclude_ = exclude |= 2;
                    this.fromForeignPointer0_cache = null;
                    state &= 0xFFFFEFFF;
                    this.state_ = state |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    l = this.fromForeignPointer(arg0Value, fromForeignPointer1_interop__, (LLVMNativeLibrary)L_L_V_M_NATIVE_LIBRARY_.getUncached(arg0Value));
                    return l;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            FromForeign0Data s11_ = this.fromForeign0_cache;
            FromForeignPointer0Data s13_ = this.fromForeignPointer0_cache;
            if (!(s11_ != null && s11_.next_ != null || s13_ != null && s13_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToI64 create() {
        return new ToI64NodeGen();
    }

    @GeneratedBy(value=ToI64.class)
    private static final class FromForeignPointer0Data
    extends Node {
        @Node.Child
        FromForeignPointer0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        LLVMNativeLibrary nativeLib_;

        FromForeignPointer0Data(FromForeignPointer0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=ToI64.class)
    private static final class FromForeign0Data
    extends Node {
        @Node.Child
        FromForeign0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        BranchProfile exception_;

        FromForeign0Data(FromForeign0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

