/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMForeignCallNode.class)
public final class LLVMForeignCallNodeFactory {

    @GeneratedBy(value=LLVMForeignCallNode.PackForeignArgumentsNode.class)
    static final class PackForeignArgumentsNodeGen
    extends LLVMForeignCallNode.PackForeignArgumentsNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private PackCachedArgCountData packCachedArgCount_cache;
        @Node.Child
        private ForeignToLLVM packGeneric_varargsToLLVM_;

        private PackForeignArgumentsNodeGen(Type[] parameterTypes, LLVMInteropType interopType) {
            super(parameterTypes, interopType);
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        Object[] execute(Object[] arg0Value, LLVMStack.StackPointer arg1Value) throws ArityException {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && arg0Value.length == this.toLLVM.length) {
                    return this.packNonVarargs(arg0Value, arg1Value);
                }
                if ((state & 2) != 0) {
                    PackCachedArgCountData s2_ = this.packCachedArgCount_cache;
                    while (s2_ != null) {
                        if (this.checkLength(arg0Value.length, s2_.varargsToLLVM_)) {
                            return this.packCachedArgCount(arg0Value, arg1Value, s2_.varargsToLLVM_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0 && arg0Value.length >= this.toLLVM.length) {
                    return this.packGeneric(arg0Value, arg1Value, this.packGeneric_varargsToLLVM_);
                }
                if ((state & 8) != 0 && arg0Value.length < this.toLLVM.length) {
                    return this.error(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object[] executeAndSpecialize(Object[] arg0Value, LLVMStack.StackPointer arg1Value) throws ArityException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0 && arg0Value.length == this.toLLVM.length) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object[] objectArray = this.packNonVarargs(arg0Value, arg1Value);
                    return objectArray;
                }
                if ((exclude & 2) == 0) {
                    Node[] varargsToLLVM__;
                    int count2_ = 0;
                    PackCachedArgCountData s2_ = this.packCachedArgCount_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && !this.checkLength(arg0Value.length, s2_.varargsToLLVM_)) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && this.checkLength(arg0Value.length, (ForeignToLLVM[])(varargsToLLVM__ = (ForeignToLLVM[])super.insert((Node[])this.createVarargsToLLVM(arg0Value.length)))) && count2_ < 3) {
                        s2_ = (PackCachedArgCountData)super.insert((Node)new PackCachedArgCountData(this.packCachedArgCount_cache));
                        s2_.varargsToLLVM_ = (ForeignToLLVM[])s2_.insertAccessor(varargsToLLVM__);
                        this.packCachedArgCount_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object[] objectArray = this.packCachedArgCount(arg0Value, arg1Value, s2_.varargsToLLVM_);
                        return objectArray;
                    }
                }
                if (arg0Value.length >= this.toLLVM.length) {
                    this.packGeneric_varargsToLLVM_ = (ForeignToLLVM)super.insert((Node)this.createVarargsToLLVM());
                    this.exclude_ = exclude |= 3;
                    this.packCachedArgCount_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object[] objectArray = this.packGeneric(arg0Value, arg1Value, this.packGeneric_varargsToLLVM_);
                    return objectArray;
                }
                if (arg0Value.length < this.toLLVM.length) {
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object[] objectArray = this.error(arg0Value, arg1Value);
                    return objectArray;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            PackCachedArgCountData s2_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s2_ = this.packCachedArgCount_cache) == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMForeignCallNode.PackForeignArgumentsNode create(Type[] parameterTypes, LLVMInteropType interopType) {
            return new PackForeignArgumentsNodeGen(parameterTypes, interopType);
        }

        @GeneratedBy(value=LLVMForeignCallNode.PackForeignArgumentsNode.class)
        private static final class PackCachedArgCountData
        extends Node {
            @Node.Child
            PackCachedArgCountData next_;
            @Node.Children
            ForeignToLLVM[] varargsToLLVM_;

            PackCachedArgCountData(PackCachedArgCountData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T[] insertAccessor(T[] node) {
                return super.insert(node);
            }
        }
    }
}

