/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.global;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class LLVMGlobal
implements LLVMSymbol {
    private final LLVMContext context;
    private final LLVMSourceSymbol sourceSymbol;
    private final boolean readOnly;
    private final AssumedValue<Object> target = new AssumedValue("llvm global", null);
    @CompilerDirectives.CompilationFinal
    private String name;
    @CompilerDirectives.CompilationFinal
    private PointerType type;
    @CompilerDirectives.CompilationFinal
    private LLVMContext.ExternalLibrary library;
    @CompilerDirectives.CompilationFinal
    private boolean interopTypeCached;
    @CompilerDirectives.CompilationFinal
    private LLVMInteropType interopType;

    public static LLVMGlobal create(LLVMContext context, String name, PointerType type, LLVMSourceSymbol sourceSymbol, boolean readOnly) {
        return new LLVMGlobal(context, name, type, sourceSymbol, readOnly);
    }

    private LLVMGlobal(LLVMContext context, String name, PointerType type, LLVMSourceSymbol sourceSymbol, boolean readOnly) {
        this.context = context;
        this.name = name;
        this.type = type;
        this.sourceSymbol = sourceSymbol;
        this.readOnly = readOnly;
        this.library = null;
        this.interopTypeCached = false;
        this.interopType = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LLVMContext.ExternalLibrary getLibrary() {
        return this.library;
    }

    public LLVMInteropType getInteropType() {
        if (!this.interopTypeCached) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            LLVMSourceType sourceType = this.sourceSymbol != null ? this.sourceSymbol.getType() : null;
            this.interopType = this.context.getInteropType(sourceType);
            this.interopTypeCached = true;
        }
        return this.interopType;
    }

    public String getSourceName() {
        return this.sourceSymbol != null ? this.sourceSymbol.getName() : this.name;
    }

    public Type getPointeeType() {
        return this.type.getPointeeType();
    }

    @Override
    public boolean isDefined() {
        return this.library != null;
    }

    public void define(LLVMContext.ExternalLibrary newLibrary) {
        this.define(this.type, newLibrary);
    }

    public void define(PointerType newType, LLVMContext.ExternalLibrary newLibrary) {
        assert (newType != null && newLibrary != null);
        if (this.isDefined()) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)("Found multiple definitions of global " + this.getName() + "."));
        }
        this.type = newType;
        this.library = newLibrary;
    }

    public Object getTarget() {
        assert (this.target.get() != null);
        return this.target.get();
    }

    public boolean isInitialized() {
        return this.target.get() != null;
    }

    public void setTarget(Object target) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.target.set(target);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isGlobalVariable() {
        return true;
    }

    @Override
    public LLVMFunctionDescriptor asFunction() {
        throw new IllegalStateException("Global " + this.name + " is not a function.");
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        return this;
    }
}

