/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.scope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class LLVMDebuggerScopeEntries
extends LLVMDebuggerValue {
    static final LLVMDebuggerScopeEntries EMPTY_SCOPE = new LLVMDebuggerScopeEntries();
    private final Map<String, Object> entries = new HashMap<String, Object>();

    LLVMDebuggerScopeEntries() {
    }

    @CompilerDirectives.TruffleBoundary
    void add(String name, Object value) {
        this.entries.put(name, value);
    }

    @CompilerDirectives.TruffleBoundary
    boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected int getElementCountForDebugger() {
        return this.entries.size();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected String[] getKeysForDebugger() {
        int count = this.getElementCountForDebugger();
        if (count == 0) {
            return NO_KEYS;
        }
        return new ArrayList<String>(this.entries.keySet()).toArray(NO_KEYS);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object getElementForDebugger(String key) {
        return this.entries.get(key);
    }

    @CompilerDirectives.TruffleBoundary
    void removeElement(String key) {
        this.entries.remove(key);
    }
}

