/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class LLDBSupport {
    private final LLVMLanguage language;
    private final EconomicMap<Type, CallTarget> loadFunctionCache;
    private LLVMDebugValue.Builder cachedDebugValueBuilder;
    private LLVMDebugValue.Builder cachedDebugDeclarationBuilder;

    public LLDBSupport(LLVMLanguage language) {
        this.language = language;
        this.loadFunctionCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
    }

    @CompilerDirectives.TruffleBoundary
    public CallTarget getLoadFunction(Type loadType) {
        CallTarget ret = (CallTarget)this.loadFunctionCache.get((Object)loadType);
        if (ret == null) {
            ret = Truffle.getRuntime().createCallTarget((RootNode)new LoadRootNode(this, loadType));
            this.loadFunctionCache.put((Object)loadType, (Object)ret);
        }
        return ret;
    }

    public static boolean pointsToObjectAccess(LLVMPointer pointer) {
        if (!LLVMManagedPointer.isInstance(pointer)) {
            return false;
        }
        LLVMManagedPointer managedPointer = LLVMManagedPointer.cast(pointer);
        Object target = managedPointer.getObject();
        return target instanceof DynamicObject && ((DynamicObject)target).getShape().getObjectType() instanceof LLVMObjectAccess;
    }

    public LLVMDebugValue.Builder createDebugValueBuilder() {
        if (this.cachedDebugValueBuilder == null) {
            this.cachedDebugValueBuilder = new WrappedBuilder(CommonNodeFactory.createDebugValueBuilder(), this.language);
        }
        return this.cachedDebugValueBuilder;
    }

    public LLVMDebugValue.Builder createDebugDeclarationBuilder() {
        if (this.cachedDebugDeclarationBuilder == null) {
            this.cachedDebugDeclarationBuilder = new WrappedBuilder(CommonNodeFactory.createDebugDeclarationBuilder(), this.language);
        }
        return this.cachedDebugDeclarationBuilder;
    }

    private static boolean isByteAligned(long bits) {
        return (bits & 7L) == 0L;
    }

    public static String toSizeString(int bitSize) {
        return LLDBSupport.toSizeString((long)bitSize);
    }

    public static String toSizeString(long bitSize) {
        if (bitSize == 0L) {
            return "0 bits";
        }
        if (bitSize == 1L) {
            return "1 bit";
        }
        if (!LLDBSupport.isByteAligned(bitSize)) {
            return String.format("%d bits", bitSize);
        }
        long byteSize = bitSize / 8L;
        if (byteSize == 1L) {
            return "1 byte";
        }
        return String.format("%d bytes", byteSize);
    }

    public static boolean isNestedManagedPointer(LLVMPointer base) {
        if (!LLVMManagedPointer.isInstance(base)) {
            return false;
        }
        LLVMManagedPointer pointer = LLVMManagedPointer.cast(base);
        return LLVMPointer.isInstance(pointer.getObject()) && pointer.getOffset() == 0L;
    }

    private static final class WrappedBuilder
    implements LLVMDebugValue.Builder {
        private final CallTarget callTarget;

        WrappedBuilder(LLVMDebugValue.Builder inner, LLVMLanguage language) {
            BuilderRootNode root = new BuilderRootNode(inner, language);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)root);
        }

        @Override
        public LLVMDebugValue build(Object irValue) {
            return (LLVMDebugValue)this.callTarget.call(new Object[]{irValue});
        }
    }

    private static final class BuilderRootNode
    extends RootNode {
        @Node.Child
        LLVMDebugValue.Builder builder;

        BuilderRootNode(LLVMDebugValue.Builder builder, LLVMLanguage language) {
            super((TruffleLanguage)language);
            this.builder = builder;
        }

        public Object execute(VirtualFrame frame) {
            return this.builder.build(frame.getArguments()[0]);
        }
    }

    private static final class LoadRootNode
    extends RootNode {
        @Node.Child
        LLVMLoadNode loadNode;

        LoadRootNode(LLDBSupport dbSupport, Type loadType) {
            super((TruffleLanguage)dbSupport.language);
            this.loadNode = CommonNodeFactory.createLoad(loadType, null);
        }

        public Object execute(VirtualFrame frame) {
            LLVMPointer offsetPointer = LLVMPointer.cast(frame.getArguments()[0]);
            return this.loadNode.executeWithTarget(offsetPointer);
        }
    }
}

