/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class LLVMIVarBit {
    public abstract LLVMIVarBit copy();

    public abstract byte getByteValue();

    public abstract byte getZeroExtendedByteValue();

    public abstract short getShortValue();

    public abstract short getZeroExtendedShortValue();

    public abstract int getIntValue();

    public abstract int getZeroExtendedIntValue();

    public abstract long getLongValue();

    public abstract long getZeroExtendedLongValue();

    public abstract int getBitSize();

    public abstract byte[] getBytes();

    public abstract LLVMIVarBit add(LLVMIVarBit var1);

    public abstract LLVMIVarBit mul(LLVMIVarBit var1);

    public abstract LLVMIVarBit sub(LLVMIVarBit var1);

    public abstract LLVMIVarBit div(LLVMIVarBit var1);

    public abstract LLVMIVarBit rem(LLVMIVarBit var1);

    public abstract LLVMIVarBit unsignedRem(LLVMIVarBit var1);

    public abstract LLVMIVarBit unsignedDiv(LLVMIVarBit var1);

    public abstract boolean isEqual(LLVMIVarBit var1);

    public abstract LLVMIVarBit and(LLVMIVarBit var1);

    public abstract LLVMIVarBit or(LLVMIVarBit var1);

    public abstract LLVMIVarBit xor(LLVMIVarBit var1);

    public abstract LLVMIVarBit leftShift(LLVMIVarBit var1);

    public abstract LLVMIVarBit logicalRightShift(LLVMIVarBit var1);

    public abstract LLVMIVarBit arithmeticRightShift(LLVMIVarBit var1);

    public abstract int signedCompare(LLVMIVarBit var1);

    public abstract int unsignedCompare(LLVMIVarBit var1);

    public abstract boolean isZero();

    public abstract BigInteger getDebugValue(boolean var1);

    public static LLVMIVarBit create(int bits, byte[] loadedBytes, int loadedArrBits, boolean signExtend) {
        if (bits <= 64) {
            return new LLVMIVarBitSmall(bits, loadedBytes, loadedArrBits, signExtend);
        }
        return new LLVMIVarBitLarge(bits, loadedBytes, loadedArrBits, signExtend);
    }

    public static LLVMIVarBit create(int bits, long loadedValue, int loadedArrBits, boolean signExtend) {
        if (bits <= 64) {
            return new LLVMIVarBitSmall(bits, loadedValue);
        }
        return new LLVMIVarBitLarge(bits, ByteBuffer.allocate(8).putLong(loadedValue).array(), loadedArrBits, signExtend);
    }

    public static LLVMIVarBit createZeroExt(int bits, byte from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(1).put(from).array(), 8, false);
    }

    public static LLVMIVarBit createZeroExt(int bits, short from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(2).putShort(from).array(), 16, false);
    }

    public static LLVMIVarBit createZeroExt(int bits, int from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(4).putInt(from).array(), 32, false);
    }

    public static LLVMIVarBit createZeroExt(int bits, long from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(8).putLong(from).array(), 64, false);
    }

    public static LLVMIVarBit fromBigInteger(int bits, BigInteger from) {
        assert (bits > 64);
        return LLVMIVarBitLarge.asIVar(bits, from);
    }

    public static LLVMIVarBit fromByte(int bits, byte from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(1).put(from).array(), 8, true);
    }

    public static LLVMIVarBit fromShort(int bits, short from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(2).putShort(from).array(), 16, true);
    }

    public static LLVMIVarBit fromInt(int bits, int from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(4).putInt(from).array(), 32, true);
    }

    public static LLVMIVarBit fromLong(int bits, long from) {
        return LLVMIVarBit.create(bits, ByteBuffer.allocate(8).putLong(from).array(), 64, true);
    }
}

