/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMFunctionDescriptor.class)
final class LLVMFunctionDescriptorGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMFunctionDescriptorGen() {
    }

    static {
        LibraryExport.register(LLVMFunctionDescriptor.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=LLVMFunctionDescriptor.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, LLVMFunctionDescriptor.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            return new Uncached();
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof LLVMFunctionDescriptor);
            return new Cached();
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMFunctionDescriptor) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, IndirectCallNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).asPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMFunctionDescriptor)receiver).toNative();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isMemberInvocable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object receiver, String member, Object ... arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).invokeMember(member, arguments);
            }
        }

        @GeneratedBy(value=LLVMFunctionDescriptor.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private int state_;
            @CompilerDirectives.CompilationFinal
            private int exclude_;
            @Node.Child
            private CachedData cached_cache;
            @Node.Child
            private IndirectCallNode polymorphic0_call_;

            Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LLVMFunctionDescriptor) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LLVMFunctionDescriptor;
            }

            @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LLVMFunctionDescriptor arg0Value = (LLVMFunctionDescriptor)arg0Value_;
                int state = this.state_;
                if (state != 0) {
                    if ((state & 1) != 0) {
                        CachedData s1_ = this.cached_cache;
                        while (s1_ != null) {
                            if (arg0Value == s1_.cachedSelf_) {
                                return LLVMFunctionDescriptor.Execute.doCached(arg0Value, arg1Value, s1_.cachedSelf_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 2) != 0) {
                        return LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, this.polymorphic0_call_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(LLVMFunctionDescriptor arg0Value, Object[] arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if (exclude == 0) {
                        int count1_ = 0;
                        CachedData s1_ = this.cached_cache;
                        if ((state & 1) != 0) {
                            while (s1_ != null && arg0Value != s1_.cachedSelf_) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 5) {
                            s1_ = (CachedData)super.insert((Node)new CachedData(this.cached_cache));
                            s1_.cachedSelf_ = arg0Value;
                            s1_.call_ = s1_.insertAccessor(DirectCallNode.create((CallTarget)s1_.cachedSelf_.getForeignCallTarget()));
                            this.cached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = LLVMFunctionDescriptor.Execute.doCached(arg0Value, arg1Value, s1_.cachedSelf_, s1_.call_);
                            return object;
                        }
                    }
                    this.polymorphic0_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 1;
                    this.cached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = LLVMFunctionDescriptor.Execute.doPolymorphic(arg0Value, arg1Value, this.polymorphic0_call_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                CachedData s1_;
                int state = this.state_;
                if (state == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).asPointer();
            }

            public boolean isPointer(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isPointer();
            }

            public void toNative(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((LLVMFunctionDescriptor)receiver).toNative();
            }

            public boolean isExecutable(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isExecutable();
            }

            public boolean hasMembers(Object receiver) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).getMembers(includeInternal);
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).isMemberInvocable(member);
            }

            public Object invokeMember(Object receiver, String member, Object ... arguments) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.assertAdopted());
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((LLVMFunctionDescriptor)receiver).invokeMember(member, arguments);
            }

            @GeneratedBy(value=LLVMFunctionDescriptor.class)
            private static final class CachedData
            extends Node {
                @Node.Child
                CachedData next_;
                @CompilerDirectives.CompilationFinal
                LLVMFunctionDescriptor cachedSelf_;
                @Node.Child
                DirectCallNode call_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

