/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.AssumedValue;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptorFactory;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NFIContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.HashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMFunctionDescriptor
implements LLVMSymbol,
LLVMInternalTruffleObject,
Comparable<LLVMFunctionDescriptor> {
    private static final long SULONG_FUNCTION_POINTER_TAG = -2400987263648399360L;
    private final FunctionType type;
    private final LLVMContext context;
    private final int functionId;
    private LLVMContext.ExternalLibrary library;
    @CompilerDirectives.CompilationFinal
    private String name;
    private final AssumedValue<Function> function;
    @CompilerDirectives.CompilationFinal
    private TruffleObject nativeWrapper;
    @CompilerDirectives.CompilationFinal
    private long nativePointer;
    private CallTarget foreignCallTarget;

    CallTarget getForeignCallTarget() {
        if (this.foreignCallTarget == null) {
            CompilerDirectives.transferToInterpreter();
            LLVMSourceFunctionType sourceType = this.getFunction().getSourceType();
            LLVMInteropType interopType = this.context.getInteropType(sourceType);
            LLVMForeignCallNode foreignCall = new LLVMForeignCallNode(this.context.getLanguage(), this, interopType);
            this.foreignCallTarget = Truffle.getRuntime().createCallTarget((RootNode)foreignCall);
            assert (this.foreignCallTarget != null);
        }
        return this.foreignCallTarget;
    }

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xDEADFACE00000000L;
    }

    private void setFunction(Function newFunction) {
        this.function.set((Object)newFunction);
    }

    public Function getFunction() {
        return (Function)this.function.get();
    }

    public LLVMFunctionDescriptor(LLVMContext context, String name, FunctionType type, int functionId, Function function, LLVMContext.ExternalLibrary library) {
        CompilerAsserts.neverPartOfCompilation();
        this.context = context;
        this.name = name;
        this.type = type;
        this.functionId = functionId;
        this.function = new AssumedValue("LLVMFunctionDescriptor.functionAssumption", (Object)function);
        this.library = library;
    }

    public void resolveIfLazyLLVMIRFunction() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getFunction() instanceof LazyLLVMIRFunction) {
            this.getFunction().resolve(this);
            assert (this.getFunction() instanceof LLVMIRFunction);
        }
    }

    public boolean isLLVMIRFunction() {
        Function currentFunction = this.getFunction();
        return currentFunction instanceof LLVMIRFunction || currentFunction instanceof LazyLLVMIRFunction;
    }

    public boolean isIntrinsicFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.isIntrinsicFunction(LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.getUncached());
    }

    public boolean isIntrinsicFunction(ResolveFunctionNode resolve) {
        return resolve.execute(this.getFunction(), this) instanceof IntrinsicFunction;
    }

    public boolean isNativeFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.isNativeFunction(LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.getUncached());
    }

    public boolean isNativeFunction(ResolveFunctionNode resolve) {
        return resolve.execute(this.getFunction(), this) instanceof NativeFunction;
    }

    @Override
    public boolean isDefined() {
        return !(this.getFunction() instanceof UnresolvedFunction);
    }

    public void define(LLVMIntrinsicProvider intrinsicProvider, NodeFactory nodeFactory) {
        Intrinsic intrinsification = new Intrinsic(intrinsicProvider, this.name, nodeFactory);
        this.define(intrinsicProvider.getLibrary(), new IntrinsicFunction(intrinsification), true);
    }

    public void define(LLVMContext.ExternalLibrary lib, Function newFunction) {
        this.define(lib, newFunction, false);
    }

    private void define(LLVMContext.ExternalLibrary lib, Function newFunction, boolean allowReplace) {
        assert (lib != null && newFunction != null);
        if (this.isDefined() && !allowReplace) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)("Found multiple definitions of function " + this.getName() + "."));
        }
        this.library = lib;
        this.setFunction(newFunction);
    }

    public RootCallTarget getLLVMIRFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getLLVMIRFunction(LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.getUncached());
    }

    public RootCallTarget getLLVMIRFunction(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        return ((LLVMIRFunction)fn).callTarget;
    }

    public Intrinsic getIntrinsicSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getIntrinsic(LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.getUncached());
    }

    public Intrinsic getIntrinsic(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        return ((IntrinsicFunction)fn).intrinsic;
    }

    public TruffleObject getNativeFunctionSlowPath() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getNativeFunction(LLVMFunctionDescriptorFactory.ResolveFunctionNodeGen.getUncached());
    }

    public TruffleObject getNativeFunction(ResolveFunctionNode resolve) {
        Function fn = resolve.execute(this.getFunction(), this);
        TruffleObject nativeFunction = ((NativeFunction)fn).nativeFunction;
        if (nativeFunction == null) {
            CompilerDirectives.transferToInterpreter();
            throw new LLVMLinkerException("Native function " + this.getName() + " not found");
        }
        return nativeFunction;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public LLVMContext.ExternalLibrary getLibrary() {
        return this.library;
    }

    public FunctionType getType() {
        return this.type;
    }

    public String toString() {
        if (this.name != null) {
            return String.format("function@%d '%s'", this.functionId, this.name);
        }
        return String.format("function@%d (anonymous)", this.functionId);
    }

    @Override
    public int compareTo(LLVMFunctionDescriptor o) {
        return Long.compare(this.functionId, o.functionId);
    }

    public LLVMContext getContext() {
        return this.context;
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.nativePointer;
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativeWrapper != null;
    }

    @ExportMessage
    LLVMFunctionDescriptor toNative() {
        if (this.nativeWrapper == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeWrapper = this.getFunction().createNativeWrapper(this);
            try {
                this.nativePointer = ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer((Object)this.nativeWrapper);
            }
            catch (UnsupportedMessageException ex) {
                this.nativePointer = LLVMFunctionDescriptor.tagSulongFunctionPointer(this.functionId);
            }
        }
        return this;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new FunctionMembers();
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return "bind".equals(member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args) throws UnknownIdentifierException {
        if ("bind".equals(member)) {
            return this;
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public boolean isGlobalVariable() {
        return false;
    }

    @Override
    public LLVMFunctionDescriptor asFunction() {
        return this;
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        throw new IllegalStateException("Function " + this.name + " is not a global variable.");
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class FunctionMembers
    implements TruffleObject {
        FunctionMembers() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 1L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index == 0L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index == 0L) {
                return "bind";
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(limit="5", guards={"self == cachedSelf"})
        static Object doCached(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self") LLVMFunctionDescriptor cachedSelf, @Cached(value="create(cachedSelf.getForeignCallTarget())") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doCached"})
        static Object doPolymorphic(LLVMFunctionDescriptor self, Object[] args, @Cached IndirectCallNode call) {
            return call.call(self.getForeignCallTarget(), args);
        }
    }

    public static interface LazyToTruffleConverter {
        public RootCallTarget convert();

        public LLVMSourceFunctionType getSourceType();
    }

    public static final class NativeFunction
    extends Function {
        private final TruffleObject nativeFunction;

        public NativeFunction(TruffleObject nativeFunction) {
            this.nativeFunction = nativeFunction;
        }

        @Override
        TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            return this.nativeFunction;
        }
    }

    public static final class IntrinsicFunction
    extends ManagedFunction {
        private final Intrinsic intrinsic;

        public IntrinsicFunction(Intrinsic intrinsic) {
            this.intrinsic = intrinsic;
        }
    }

    public static final class UnresolvedFunction
    extends Function {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void resolve(LLVMFunctionDescriptor descriptor) {
            LLVMContext context;
            CompilerAsserts.neverPartOfCompilation();
            LLVMContext lLVMContext = context = descriptor.getContext();
            synchronized (lLVMContext) {
                NFIContextExtension.NativeLookupResult nativeFunction;
                if (descriptor.getFunction() != this) {
                    return;
                }
                NFIContextExtension nfiContextExtension = context.getLanguage().getContextExtensionOrNull(NFIContextExtension.class);
                LLVMIntrinsicProvider intrinsicProvider = context.getLanguage().getCapability(LLVMIntrinsicProvider.class);
                assert (!intrinsicProvider.isIntrinsified(descriptor.getName()));
                if (nfiContextExtension != null && (nativeFunction = nfiContextExtension.getNativeFunctionOrNull(context, descriptor.getName())) != null) {
                    descriptor.define(nativeFunction.getLibrary(), new NativeFunction(nativeFunction.getObject()));
                    return;
                }
            }
            throw new LLVMLinkerException(String.format("External function %s cannot be found.", descriptor.getName()));
        }

        @Override
        TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            this.resolve(descriptor);
            return descriptor.getFunction().createNativeWrapper(descriptor);
        }
    }

    public static final class LLVMIRFunction
    extends ManagedFunction {
        private final RootCallTarget callTarget;
        private final LLVMSourceFunctionType sourceType;

        public LLVMIRFunction(RootCallTarget callTarget, LLVMSourceFunctionType sourceType) {
            this.callTarget = callTarget;
            this.sourceType = sourceType;
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.sourceType;
        }
    }

    public static final class LazyLLVMIRFunction
    extends ManagedFunction {
        private final LazyToTruffleConverter converter;

        public LazyLLVMIRFunction(LazyToTruffleConverter converter) {
            this.converter = converter;
        }

        @Override
        void resolve(LLVMFunctionDescriptor descriptor) {
            RootCallTarget callTarget = this.converter.convert();
            LLVMSourceFunctionType sourceType = this.converter.getSourceType();
            descriptor.setFunction(new LLVMIRFunction(callTarget, sourceType));
        }

        @Override
        LLVMSourceFunctionType getSourceType() {
            return this.converter.getSourceType();
        }
    }

    static abstract class ManagedFunction
    extends Function {
        ManagedFunction() {
        }

        @Override
        TruffleObject createNativeWrapper(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
            TruffleObject wrapper = null;
            LLVMNativePointer pointer = null;
            NFIContextExtension nfiContextExtension = descriptor.context.getLanguage().getContextExtensionOrNull(NFIContextExtension.class);
            if (nfiContextExtension != null && (wrapper = nfiContextExtension.createNativeWrapper(descriptor)) != null) {
                try {
                    pointer = LLVMNativePointer.create(((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer((Object)wrapper));
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new AssertionError((Object)e);
                }
            }
            if (wrapper == null) {
                pointer = LLVMNativePointer.create(LLVMFunctionDescriptor.tagSulongFunctionPointer(descriptor.functionId));
                wrapper = pointer;
            }
            descriptor.context.registerFunctionPointer(pointer, descriptor);
            return wrapper;
        }
    }

    @GenerateUncached
    public static abstract class ResolveFunctionNode
    extends LLVMNode {
        abstract Function execute(Function var1, LLVMFunctionDescriptor var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Function doLazyLLVMIRFunction(LazyLLVMIRFunction function, LLVMFunctionDescriptor descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Function doUnresolvedFunction(UnresolvedFunction function, LLVMFunctionDescriptor descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction();
        }

        private static boolean resolveDoesNothing(Function function, LLVMFunctionDescriptor descriptor) {
            function.resolve(descriptor);
            return descriptor.getFunction() == function;
        }

        @Fallback
        Function doOther(Function function, LLVMFunctionDescriptor descriptor) {
            assert (ResolveFunctionNode.resolveDoesNothing(function, descriptor));
            return function;
        }
    }

    public static abstract class Function {
        void resolve(LLVMFunctionDescriptor descriptor) {
            CompilerAsserts.neverPartOfCompilation();
        }

        abstract TruffleObject createNativeWrapper(LLVMFunctionDescriptor var1);

        LLVMSourceFunctionType getSourceType() {
            return null;
        }
    }

    public static final class Intrinsic {
        private final String intrinsicName;
        private final Map<FunctionType, RootCallTarget> overloadingMap;
        private final LLVMIntrinsicProvider provider;
        private final NodeFactory nodeFactory;

        public Intrinsic(LLVMIntrinsicProvider provider, String name, NodeFactory nodeFactory) {
            this.intrinsicName = name;
            this.overloadingMap = new HashMap<FunctionType, RootCallTarget>();
            this.provider = provider;
            this.nodeFactory = nodeFactory;
        }

        public RootCallTarget cachedCallTarget(FunctionType type) {
            if (this.exists(type)) {
                return this.get(type);
            }
            return this.generateTarget(type);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean exists(FunctionType type) {
            return this.overloadingMap.containsKey(type);
        }

        @CompilerDirectives.TruffleBoundary
        private RootCallTarget get(FunctionType type) {
            return this.overloadingMap.get(type);
        }

        private RootCallTarget generateTarget(FunctionType type) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RootCallTarget newTarget = this.provider.generateIntrinsicTarget(this.intrinsicName, type.getArgumentTypes(), this.nodeFactory);
            assert (newTarget != null);
            this.overloadingMap.put(type, newTarget);
            return newTarget;
        }

        public LLVMExpressionNode generateNode(FunctionType type, LLVMExpressionNode[] arguments) {
            CompilerAsserts.neverPartOfCompilation();
            LLVMExpressionNode node = this.provider.generateIntrinsicNode(this.intrinsicName, arguments, type.getArgumentTypes(), this.nodeFactory);
            assert (node != null);
            return node;
        }
    }
}

