/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class LLVMAlias
implements LLVMSymbol {
    private final LLVMContext.ExternalLibrary library;
    @CompilerDirectives.CompilationFinal
    private LLVMSymbol target;
    @CompilerDirectives.CompilationFinal
    private String name;

    public LLVMAlias(LLVMContext.ExternalLibrary library, String name, LLVMSymbol target) {
        this.library = library;
        this.name = name;
        this.setTarget(target);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public LLVMContext.ExternalLibrary getLibrary() {
        return this.library;
    }

    public LLVMSymbol getTarget() {
        return this.target;
    }

    public void setTarget(LLVMSymbol value) {
        this.target = value;
        if (this.target instanceof LLVMAlias) {
            EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
            this.checkForCycle(this, (EconomicSet<LLVMAlias>)visited);
        }
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public boolean isFunction() {
        return this.target.isFunction();
    }

    @Override
    public boolean isGlobalVariable() {
        return this.target.isGlobalVariable();
    }

    @Override
    public LLVMFunctionDescriptor asFunction() {
        return this.target.asFunction();
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        return this.target.asGlobalVariable();
    }

    public String toString() {
        return this.name + " -> " + this.target.getName();
    }

    private void checkForCycle(LLVMAlias alias, EconomicSet<LLVMAlias> visited) {
        if (visited.contains((Object)alias)) {
            throw new LLVMLinkerException("Found a cycle between the following aliases: " + visited.toString());
        }
        visited.add((Object)alias);
        if (alias.getTarget() instanceof LLVMAlias) {
            this.checkForCycle((LLVMAlias)alias.getTarget(), visited);
        }
    }
}

