/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.text;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.text.LLSourceSection;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class LLSourceMap {
    private final Source llSource;
    private final Map<String, Function> functions;
    private final List<String> globals;
    private LLVMSourceLocation.TextModule globalScope;

    LLSourceMap(Source llSource) {
        this.llSource = llSource;
        this.functions = new HashMap<String, Function>();
        this.globals = new ArrayList<String>();
        this.globalScope = null;
    }

    void registerFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    void registerGlobal(String name) {
        this.globals.add(name);
    }

    private LLVMSourceLocation getGlobalScope(LLVMContext context, LLVMScope moduleScope) {
        if (this.globalScope == null) {
            this.globalScope = LLVMSourceLocation.createLLModule(this.llSource.getName(), this.llSource.createSection(0, this.llSource.getLength()));
        }
        if (!this.globals.isEmpty()) {
            for (String globalName : this.globals) {
                assert (globalName.startsWith("@"));
                LLVMSymbol actualSymbol = moduleScope.get(globalName.substring(1));
                if (actualSymbol != null && actualSymbol.isGlobalVariable()) {
                    this.globalScope.addGlobal(actualSymbol.asGlobalVariable());
                    continue;
                }
                this.globalScope.addGlobal(LLVMGlobal.create(context, globalName + " (unavailable)", PointerType.VOID, null, true));
            }
            this.globals.clear();
        }
        return this.globalScope;
    }

    Function getFunction(String name) {
        return this.functions.get(LLVMIdentifier.toGlobalIdentifier(name));
    }

    void clearFunction(Function function) {
        this.functions.remove(LLVMIdentifier.toGlobalIdentifier(function.getName()));
    }

    Source getLLSource() {
        return this.llSource;
    }

    static final class Instruction {
        private final String descriptor;
        private final int line;

        Instruction(String descriptor, int line) {
            this.descriptor = descriptor;
            this.line = line;
        }

        LLVMSourceLocation toSourceLocation(Source llSource, LLVMSourceLocation parent) {
            SourceSection sourceSection = llSource.createSection(this.line);
            return LLVMSourceLocation.createLLInstruction(parent, sourceSection);
        }

        String getDescriptor() {
            return this.descriptor;
        }
    }

    static final class Function {
        private final String name;
        private final ArrayDeque<Instruction> instructionList;
        private final int startLine;
        private int endLine;

        Function(String name, int startLine) {
            this.name = name;
            this.startLine = startLine;
            this.instructionList = new ArrayDeque();
        }

        void add(String var, int line) {
            this.instructionList.add(new Instruction(var, line));
        }

        void setEndLine(int line) {
            this.endLine = line;
        }

        ArrayDeque<Instruction> getInstructionList() {
            return this.instructionList;
        }

        String getName() {
            return this.name;
        }

        LLVMSourceLocation toSourceLocation(LLSourceMap sourceMap, LLVMParserRuntime runtime) {
            Source llSource = sourceMap.getLLSource();
            SourceSection startSection = llSource.createSection(this.startLine);
            int startCharIndex = startSection.getCharIndex();
            SourceSection endSection = llSource.createSection(this.endLine);
            int charLength = endSection.getCharEndIndex() - startCharIndex;
            SourceSection totalSection = llSource.createSection(startCharIndex, charLength);
            return LLVMSourceLocation.create(sourceMap.getGlobalScope(runtime.getContext(), runtime.getFileScope()), LLVMSourceLocation.Kind.FUNCTION, this.name, new LLSourceSection(totalSection), null);
        }
    }
}

