/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.nodes;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.llvm.parser.metadata.DwarfOpcode;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.ValueFragment;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.UndefinedConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.DoubleConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.X86FP80Constant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.BigIntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.AllocateInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.ValueInstructionVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMFrameValueAccess;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import java.util.ArrayList;
import java.util.List;

public final class LLVMRuntimeDebugInformation {
    private final FrameDescriptor frame;
    private final LLVMContext context;
    private final List<FrameSlot> notNullableSlots;
    private final LLVMSymbolReadResolver symbols;
    private final boolean isEnabled;
    private final StaticValueAccessVisitor staticValueAccessVisitor;
    private static final int[] CLEAR_NONE = new int[0];

    public LLVMRuntimeDebugInformation(FrameDescriptor frame, LLVMContext context, List<FrameSlot> notNullableSlots, LLVMSymbolReadResolver symbols) {
        this.frame = frame;
        this.context = context;
        this.notNullableSlots = notNullableSlots;
        this.symbols = symbols;
        this.isEnabled = (Boolean)context.getEnv().getOptions().get(SulongEngineOption.ENABLE_LVI);
        this.staticValueAccessVisitor = new StaticValueAccessVisitor();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private static boolean mustDereferenceValue(MDExpression expr, LLVMSourceType type, SymbolImpl value) {
        return DwarfOpcode.isDeref(expr) || type != null && !type.isPointer() && value instanceof AllocateInstruction;
    }

    public void registerStaticDebugSymbols(FunctionDefinition fn) {
        if (!this.isEnabled) {
            return;
        }
        for (SourceVariable local : fn.getSourceFunction().getVariables()) {
            VoidInstruction dbg;
            if (local.isSingleDeclaration()) {
                dbg = local.getSingleDeclaration();
                FrameSlot frameSlot = null;
                if (((DbgDeclareInstruction)dbg).getValue() instanceof AllocateInstruction) {
                    frameSlot = this.frame.findFrameSlot((Object)((AllocateInstruction)((DbgDeclareInstruction)dbg).getValue()).getName());
                }
                if (frameSlot == null) continue;
                LLVMSourceSymbol symbol = local.getSymbol();
                LLVMFrameValueAccess alloc = CommonNodeFactory.createDebugFrameValue(frameSlot, true);
                this.notNullableSlots.add(frameSlot);
                this.context.getSourceContext().registerFrameValue(symbol, alloc);
                local.addStaticValue();
                continue;
            }
            if (!local.isSingleValue()) continue;
            dbg = local.getSingleValue();
            MDExpression expr = ((DbgValueInstruction)dbg).getExpression();
            SymbolImpl value = ((DbgValueInstruction)dbg).getValue();
            if (expr.getElementCount() != 0) continue;
            boolean mustDereference = LLVMRuntimeDebugInformation.mustDereferenceValue(expr, local.getSourceType(), value);
            this.staticValueAccessVisitor.registerStaticAccess(local, value, mustDereference);
        }
    }

    public LLVMStatementNode createInitializer(SourceVariable variable) {
        if (!this.isEnabled) {
            return null;
        }
        FrameSlot targetSlot = this.frame.findOrAddFrameSlot((Object)variable.getSymbol(), (Object)MetaType.DEBUG, FrameSlotKind.Object);
        int[] offsets = null;
        int[] lengths = null;
        if (variable.hasFragments()) {
            List<ValueFragment> fragments = variable.getFragments();
            offsets = new int[fragments.size()];
            lengths = new int[fragments.size()];
            for (int i = 0; i < fragments.size(); ++i) {
                ValueFragment fragment = fragments.get(i);
                offsets[i] = fragment.getOffset();
                lengths[i] = fragment.getLength();
            }
        }
        return CommonNodeFactory.createDebugValueInit(targetSlot, offsets, lengths);
    }

    LLVMStatementNode handleDebugIntrinsic(SymbolImpl value, SourceVariable variable, MDExpression expression, long index, boolean isDeclaration) {
        if (!this.isEnabled || variable.hasStaticAllocation()) {
            return null;
        }
        LLVMExpressionNode valueRead = null;
        if (isDeclaration) {
            if (value instanceof UndefinedConstant) {
                if (variable.hasValue()) {
                    return null;
                }
                valueRead = this.symbols.resolve(new NullConstant(MetaType.DEBUG));
            } else if (value instanceof NullConstant) {
                valueRead = this.symbols.resolve(new NullConstant(MetaType.DEBUG));
            } else if (value instanceof GlobalValueSymbol || value.getType() instanceof PointerType) {
                valueRead = this.symbols.resolve(value);
            }
        } else {
            valueRead = this.symbols.resolve(value);
            if (index != 0L) {
                return null;
            }
        }
        if (valueRead == null) {
            return null;
        }
        int partIndex = -1;
        int[] clearParts = null;
        if (ValueFragment.describesFragment(expression)) {
            ValueFragment fragment = ValueFragment.parse(expression);
            List<ValueFragment> siblings = variable.getFragments();
            ArrayList<Integer> clearSiblings = new ArrayList<Integer>(siblings.size());
            partIndex = ValueFragment.getPartIndex(fragment, siblings, clearSiblings);
            clearParts = clearSiblings.isEmpty() ? CLEAR_NONE : clearSiblings.stream().mapToInt(Integer::intValue).toArray();
        }
        if (partIndex < 0 && variable.hasFragments()) {
            int i;
            partIndex = variable.getFragmentIndex(0, (int)variable.getSymbol().getType().getSize());
            if (partIndex < 0) {
                throw new LLVMParserException("Cannot find index of value fragment!");
            }
            clearParts = new int[variable.getFragments().size() - 1];
            for (i = 0; i < partIndex; ++i) {
                clearParts[i] = i;
            }
            for (i = partIndex; i < clearParts.length; ++i) {
                clearParts[i] = i + 1;
            }
        }
        boolean mustDereference = isDeclaration || LLVMRuntimeDebugInformation.mustDereferenceValue(expression, variable.getSourceType(), value);
        FrameSlot targetSlot = this.frame.findOrAddFrameSlot((Object)variable.getSymbol(), (Object)MetaType.DEBUG, FrameSlotKind.Object);
        LLVMExpressionNode containerRead = CommonNodeFactory.createFrameRead(MetaType.DEBUG, targetSlot);
        return CommonNodeFactory.createDebugValueUpdate(mustDereference, valueRead, targetSlot, containerRead, partIndex, clearParts);
    }

    private final class StaticValueAccessVisitor
    extends ValueInstructionVisitor {
        private SourceVariable variable = null;
        private LLVMSourceSymbol symbol = null;
        private boolean isDeclaration = false;

        private StaticValueAccessVisitor() {
        }

        void registerStaticAccess(SourceVariable descriptor, SymbolImpl value, boolean mustDereference) {
            this.variable = descriptor;
            this.symbol = this.variable.getSymbol();
            this.isDeclaration = mustDereference;
            if (value != null) {
                value.accept(this);
            }
            this.variable = null;
            this.symbol = null;
            this.isDeclaration = false;
        }

        private void visitFrameValue(String name) {
            FrameSlot slot = LLVMRuntimeDebugInformation.this.frame.findFrameSlot((Object)name);
            assert (slot != null);
            LLVMFrameValueAccess valueAccess = CommonNodeFactory.createDebugFrameValue(slot, this.isDeclaration);
            LLVMRuntimeDebugInformation.this.context.getSourceContext().registerFrameValue(this.symbol, valueAccess);
            LLVMRuntimeDebugInformation.this.notNullableSlots.add(slot);
            this.variable.addStaticValue();
        }

        private void visitSimpleConstant(SymbolImpl constant) {
            LLVMExpressionNode node = LLVMRuntimeDebugInformation.this.symbols.resolve(constant);
            assert (node != null);
            LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, false);
            LLVMRuntimeDebugInformation.this.context.getSourceContext().registerStatic(this.symbol, value);
            this.variable.addStaticValue();
        }

        @Override
        public void visitValueInstruction(ValueInstruction inst) {
            this.visitFrameValue(inst.getName());
        }

        @Override
        public void visit(FunctionParameter param) {
            this.visitFrameValue(param.getName());
        }

        @Override
        public void visit(IntegerConstant constant) {
            this.visitSimpleConstant(constant);
        }

        @Override
        public void visit(BigIntegerConstant constant) {
            this.visitSimpleConstant(constant);
        }

        @Override
        public void visit(DoubleConstant constant) {
            this.visitSimpleConstant(constant);
        }

        @Override
        public void visit(FloatConstant constant) {
            this.visitSimpleConstant(constant);
        }

        @Override
        public void visit(X86FP80Constant constant) {
            this.visitSimpleConstant(constant);
        }

        @Override
        public void visit(GlobalVariable global) {
            if (global.isReadOnly()) {
                this.visitSimpleConstant(global);
            } else {
                super.visit(global);
            }
        }

        @Override
        public void visit(NullConstant constant) {
            if (constant.getType() instanceof PrimitiveType || constant.getType() instanceof PointerType || constant.getType() instanceof FunctionType) {
                this.visitSimpleConstant(constant);
            }
        }
    }
}

