/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.AtomicOrdering;
import com.oracle.truffle.llvm.parser.model.enums.SynchronizationScope;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class LoadInstruction
extends ValueInstruction {
    private final AtomicOrdering atomicOrdering;
    private final boolean isVolatile;
    private final SynchronizationScope synchronizationScope;
    private SymbolImpl source;

    private LoadInstruction(Type type, boolean isVolatile, AtomicOrdering ordering, SynchronizationScope scope) {
        super(type);
        this.isVolatile = isVolatile;
        this.atomicOrdering = ordering;
        this.synchronizationScope = scope;
    }

    private static LoadInstruction fromSymbols(SymbolTable symbols, Type type, int source, boolean isVolatile, AtomicOrdering atomicOrdering, SynchronizationScope synchronizationScope) {
        LoadInstruction inst = new LoadInstruction(type, isVolatile, atomicOrdering, synchronizationScope);
        inst.source = symbols.getForwardReferenced(source, inst);
        return inst;
    }

    public static LoadInstruction fromSymbols(SymbolTable symbols, Type type, int source, boolean isVolatile) {
        return LoadInstruction.fromSymbols(symbols, type, source, isVolatile, AtomicOrdering.NOT_ATOMIC, SynchronizationScope.CROSS_THREAD);
    }

    public static LoadInstruction fromSymbols(SymbolTable symbols, Type type, int source, boolean isVolatile, long atomicOrdering, long synchronizationScope) {
        return LoadInstruction.fromSymbols(symbols, type, source, isVolatile, AtomicOrdering.decode(atomicOrdering), SynchronizationScope.decode(synchronizationScope));
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public AtomicOrdering getAtomicOrdering() {
        return this.atomicOrdering;
    }

    public SymbolImpl getSource() {
        return this.source;
    }

    public SynchronizationScope getSynchronizationScope() {
        return this.synchronizationScope;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.source == original) {
            this.source = replacement;
        }
    }
}

