/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class GetElementPointerInstruction
extends ValueInstruction {
    private SymbolImpl base;
    private final SymbolImpl[] indices;
    private final boolean isInbounds;

    private GetElementPointerInstruction(Type type, boolean isInbounds, int numIndices) {
        super(type);
        this.indices = new SymbolImpl[numIndices];
        this.isInbounds = isInbounds;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getBasePointer() {
        return this.base;
    }

    public List<SymbolImpl> getIndices() {
        return Collections.unmodifiableList(Arrays.asList(this.indices));
    }

    public boolean isInbounds() {
        return this.isInbounds;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.base == original) {
            this.base = replacement;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] != original) continue;
            this.indices[i] = replacement;
        }
    }

    public static GetElementPointerInstruction fromSymbols(SymbolTable symbols, Type type, int pointer, int[] indices, boolean isInbounds) {
        GetElementPointerInstruction inst = new GetElementPointerInstruction(type, isInbounds, indices.length);
        inst.base = symbols.getForwardReferenced(pointer, inst);
        for (int i = 0; i < indices.length; ++i) {
            inst.indices[i] = symbols.getForwardReferenced(indices[i], inst);
        }
        return inst;
    }
}

