/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint;

import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatingPointConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;

public final class FloatConstant
extends FloatingPointConstant {
    private final float value;

    FloatConstant(float value) {
        super(PrimitiveType.FLOAT);
        this.value = value;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public float getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%.6f", Float.valueOf(this.value));
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }
}

