/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class SelectConstant
extends AbstractConstant {
    private SymbolImpl condition;
    private SymbolImpl trueValue;
    private SymbolImpl falseValue;

    private SelectConstant(Type type) {
        super(type);
    }

    public SymbolImpl getCondition() {
        return this.condition;
    }

    public SymbolImpl getTrueValue() {
        return this.trueValue;
    }

    public SymbolImpl getFalseValue() {
        return this.falseValue;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.condition == original) {
            this.condition = replacement;
        }
        if (this.falseValue == original) {
            this.falseValue = replacement;
        }
        if (this.trueValue == original) {
            this.trueValue = replacement;
        }
    }

    public static SelectConstant fromSymbols(SymbolTable symbols, Type type, int condition, int trueValue, int falseValue) {
        SelectConstant constant = new SelectConstant(type);
        constant.condition = symbols.getForwardReferenced(condition, constant);
        constant.trueValue = symbols.getForwardReferenced(trueValue, constant);
        constant.falseValue = symbols.getForwardReferenced(falseValue, constant);
        return constant;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }
}

