/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model;

import com.oracle.truffle.llvm.parser.ValueList;
import com.oracle.truffle.llvm.parser.metadata.MDAttachment;
import com.oracle.truffle.llvm.parser.metadata.MetadataAttachmentHolder;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public final class SymbolTable
extends ValueList<SymbolImpl, SymbolVisitor> {
    private static final ValueList.PlaceholderFactory<SymbolImpl, SymbolVisitor> PLACEHOLDER_FACTORY = () -> new SymbolImpl(){

        @Override
        public Type getType() {
            return VoidType.INSTANCE;
        }

        @Override
        public void accept(SymbolVisitor visitor) {
            throw new LLVMParserException("Unresolved Forward Reference!");
        }

        @Override
        public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
            throw new LLVMParserException("Cannot replace Symbol in Forward Reference!");
        }

        public String toString() {
            return "Forward Referenced Symbol";
        }
    };

    public SymbolTable() {
        super(PLACEHOLDER_FACTORY);
    }

    public void nameSymbol(int index, String name) {
        SymbolImpl symbol = (SymbolImpl)this.getOrNull(index);
        if (symbol instanceof ValueSymbol) {
            ((ValueSymbol)symbol).setName(name);
        } else if (symbol == null) {
            this.onParse(index, s -> {
                if (s instanceof ValueSymbol) {
                    ((ValueSymbol)s).setName(name);
                }
            });
        }
    }

    public void attachMetadata(int index, MDAttachment attachment) {
        SymbolImpl symbol = (SymbolImpl)this.getOrNull(index);
        if (symbol instanceof MetadataAttachmentHolder) {
            ((MetadataAttachmentHolder)((Object)symbol)).attachMetadata(attachment);
        } else if (symbol == null) {
            this.onParse(index, s -> {
                if (s instanceof MetadataAttachmentHolder) {
                    ((MetadataAttachmentHolder)((Object)s)).attachMetadata(attachment);
                }
            });
        }
    }
}

