/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDType;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.records.DwTagRecord;

public final class MDCompositeType
extends MDType
implements MDBaseNode {
    private final long runtimeLanguage;
    private MDBaseNode scope;
    private MDBaseNode baseType;
    private MDBaseNode members;
    private MDBaseNode templateParams;
    private MDBaseNode identifier;
    private static final int ARGINDEX_38_TAG = 1;
    private static final int ARGINDEX_38_NAME = 2;
    private static final int ARGINDEX_38_FILE = 3;
    private static final int ARGINDEX_38_LINE = 4;
    private static final int ARGINDEX_38_SCOPE = 5;
    private static final int ARGINDEX_38_BASETYPE = 6;
    private static final int ARGINDEX_38_SIZE = 7;
    private static final int ARGINDEX_38_ALIGN = 8;
    private static final int ARGINDEX_38_OFFSET = 9;
    private static final int ARGINDEX_38_FLAGS = 10;
    private static final int ARGINDEX_38_MEMBERS = 11;
    private static final int ARGINDEX_38_RUNTIMELANGUAGE = 12;
    private static final int ARGINDEX_38_TEMPLATEPARAMS = 14;
    private static final int ARGINDEX_38_IDENTIFIER = 15;
    private static final int ARGINDEX_32_TAG = 0;
    private static final int ARGINDEX_32_SCOPE = 1;
    private static final int ARGINDEX_32_NAME = 2;
    private static final int ARGINDEX_32_FILE = 3;
    private static final int ARGINDEX_32_LINE = 4;
    private static final int ARGINDEX_32_SIZE = 5;
    private static final int ARGINDEX_32_ALIGN = 6;
    private static final int ARGINDEX_32_OFFSET = 7;
    private static final int ARGINDEX_32_FLAGS = 8;
    private static final int ARGINDEX_32_BASETYPE = 9;
    private static final int ARGINDEX_32_MEMBERS = 10;
    private static final int ARGINDEX_32_RUNTIMELANGUAGE = 11;
    private static final int ARGINDEX_32_TEMPLATEPARAMS = 13;

    private MDCompositeType(long tag, long line, long size, long align, long offset, long flags, long runtimeLanguage) {
        super(tag, size, align, offset, line, flags);
        this.runtimeLanguage = runtimeLanguage;
        this.scope = MDVoidNode.INSTANCE;
        this.baseType = MDVoidNode.INSTANCE;
        this.members = MDVoidNode.INSTANCE;
        this.templateParams = MDVoidNode.INSTANCE;
        this.identifier = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    public MDBaseNode getBaseType() {
        return this.baseType;
    }

    public MDBaseNode getMembers() {
        return this.members;
    }

    public long getRuntimeLanguage() {
        return this.runtimeLanguage;
    }

    public MDBaseNode getTemplateParams() {
        return this.templateParams;
    }

    public MDBaseNode getIdentifier() {
        return this.identifier;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
        if (this.baseType == oldValue) {
            this.baseType = newValue;
        }
        if (this.members == oldValue) {
            this.members = newValue;
        }
        if (this.templateParams == oldValue) {
            this.templateParams = newValue;
        }
        if (this.identifier == oldValue) {
            this.identifier = newValue;
        }
    }

    public static MDCompositeType create38(long[] args, MetadataValueList md) {
        long tag = args[1];
        long line = args[4];
        long size = args[7];
        long align = args[8];
        long offset = args[9];
        long flags = args[10];
        long lang = args[12];
        MDCompositeType compositeType = new MDCompositeType(tag, line, size, align, offset, flags, lang);
        compositeType.scope = md.getNullable(args[5], compositeType);
        compositeType.baseType = md.getNullable(args[6], compositeType);
        compositeType.members = md.getNullable(args[11], compositeType);
        compositeType.templateParams = md.getNullable(args[14], compositeType);
        compositeType.identifier = md.getNullable(args[15], compositeType);
        compositeType.setFile(md.getNullable(args[3], compositeType));
        compositeType.setName(md.getNullable(args[2], compositeType));
        return compositeType;
    }

    public static MDCompositeType create32(long[] args, Metadata md) {
        long tag = DwTagRecord.decode(ParseUtil.asLong(args, 0, md)).code();
        long line = ParseUtil.asInt(args, 4, md);
        long size = ParseUtil.asLong(args, 5, md);
        long align = ParseUtil.asLong(args, 6, md);
        long offset = ParseUtil.asLong(args, 7, md);
        long flags = ParseUtil.asInt(args, 8, md);
        long lang = ParseUtil.asLong(args, 11, md);
        MDCompositeType compositeType = new MDCompositeType(tag, line, size, align, offset, flags, lang);
        compositeType.scope = ParseUtil.resolveReference(args, 1, compositeType, md);
        compositeType.baseType = ParseUtil.resolveReference(args, 9, compositeType, md);
        compositeType.members = ParseUtil.resolveReference(args, 10, compositeType, md);
        compositeType.templateParams = ParseUtil.resolveReference(args, 13, compositeType, md);
        compositeType.setFile(ParseUtil.resolveReference(args, 3, compositeType, md));
        compositeType.setName(ParseUtil.resolveReference(args, 2, compositeType, md));
        return compositeType;
    }
}

