/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.binary;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.binary.BinaryParserResult;
import com.oracle.truffle.llvm.parser.elf.ElfDynamicSection;
import com.oracle.truffle.llvm.parser.elf.ElfFile;
import com.oracle.truffle.llvm.parser.elf.ElfLibraryLocator;
import com.oracle.truffle.llvm.parser.elf.ElfSectionHeaderTable;
import com.oracle.truffle.llvm.parser.macho.MachOFile;
import com.oracle.truffle.llvm.parser.macho.MachOLibraryLocator;
import com.oracle.truffle.llvm.parser.macho.Xar;
import com.oracle.truffle.llvm.parser.scanner.BitStream;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.polyglot.io.ByteSequence;

public final class BinaryParser {
    private ArrayList<String> libraries = new ArrayList();
    private ArrayList<String> paths = new ArrayList();
    private LibraryLocator locator = DefaultLibraryLocator.INSTANCE;

    public static BinaryParserResult parse(ByteSequence bytes, Source bcSource, LLVMContext context) {
        return new BinaryParser().parseInternal(bytes, bcSource, context);
    }

    private BinaryParserResult parseInternal(ByteSequence bytes, Source bcSource, LLVMContext context) {
        assert (bytes != null);
        ByteSequence bitcode = this.parseBitcode(bytes, bcSource);
        if (bitcode == null) {
            return null;
        }
        if (bcSource != null) {
            LibraryLocator.traceParseBitcode(context, bcSource.getPath());
        }
        return new BinaryParserResult(this.libraries, this.paths, bitcode, this.locator);
    }

    public static String getOrigin(Source source) {
        if (source == null) {
            return null;
        }
        String sourcePath = source.getPath();
        if (sourcePath == null) {
            return null;
        }
        Path parent = Paths.get(sourcePath, new String[0]).getParent();
        if (parent == null) {
            return null;
        }
        return parent.toString();
    }

    private ByteSequence parseBitcode(ByteSequence bytes, Source source) {
        BitStream b = BitStream.create(bytes);
        Magic magicWord = Magic.get(b);
        switch (magicWord) {
            case BC_MAGIC_WORD: {
                return bytes;
            }
            case WRAPPER_MAGIC_WORD: {
                long offset = b.read(64L, 32);
                long size = b.read(96L, 32);
                return bytes.subSequence((int)offset, (int)(offset + size));
            }
            case ELF_MAGIC_WORD: {
                ElfFile elfFile = ElfFile.create(bytes);
                ElfSectionHeaderTable.Entry llvmbc = elfFile.getSectionHeaderTable().getEntry(".llvmbc");
                if (llvmbc == null) {
                    return null;
                }
                ElfDynamicSection dynamicSection = elfFile.getDynamicSection();
                if (dynamicSection != null) {
                    List<String> elfLibraries = dynamicSection.getDTNeeded();
                    this.libraries.addAll(elfLibraries);
                    this.locator = new ElfLibraryLocator(elfFile, source);
                }
                long elfOffset = llvmbc.getOffset();
                long elfSize = llvmbc.getSize();
                return bytes.subSequence((int)elfOffset, (int)(elfOffset + elfSize));
            }
            case MH_MAGIC: 
            case MH_CIGAM: 
            case MH_MAGIC_64: 
            case MH_CIGAM_64: {
                MachOFile machOFile = MachOFile.create(bytes);
                String origin = BinaryParser.getOrigin(source);
                List<String> machoLibraries = machOFile.getDyLibs(origin);
                this.locator = new MachOLibraryLocator(machOFile, source);
                this.libraries.addAll(machoLibraries);
                ByteSequence machoBitcode = machOFile.extractBitcode();
                if (machoBitcode == null) {
                    return null;
                }
                return this.parseBitcode(machoBitcode, source);
            }
            case XAR_MAGIC: {
                Xar xarFile = Xar.create(bytes);
                ByteSequence xarBitcode = xarFile.extractBitcode();
                if (xarBitcode == null) {
                    return null;
                }
                return this.parseBitcode(xarBitcode, source);
            }
        }
        return null;
    }

    public static enum Magic {
        BC_MAGIC_WORD(3737142082L),
        WRAPPER_MAGIC_WORD(186106078L),
        ELF_MAGIC_WORD(1179403647L),
        MH_MAGIC(4277009102L),
        MH_CIGAM(3472551422L),
        MH_MAGIC_64(4277009103L),
        MH_CIGAM_64(3489328638L),
        XAR_MAGIC(561144184L),
        UNKNOWN(0L);

        public final long magic;
        private static final Magic[] VALUES;

        private Magic(long magic) {
            this.magic = magic;
        }

        public static Magic get(long magic) {
            for (Magic m : VALUES) {
                if (m.magic != magic) continue;
                return m;
            }
            return UNKNOWN;
        }

        public static Magic get(BitStream b) {
            try {
                return Magic.get(Integer.toUnsignedLong((int)b.read(0L, 32)));
            }
            catch (Exception e) {
                return UNKNOWN;
            }
        }

        static {
            VALUES = Magic.values();
        }
    }
}

