/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.PhiInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.FunctionVisitor;
import com.oracle.truffle.llvm.parser.model.visitors.InstructionVisitorAdapter;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class LLVMPhiManager {
    private LLVMPhiManager() {
    }

    public static Map<InstructionBlock, List<Phi>> getPhis(FunctionDefinition function) {
        HashMap<InstructionBlock, List<Phi>> phiMap = new HashMap<InstructionBlock, List<Phi>>();
        function.accept(new LLVMPhiManagerFunctionVisitor(phiMap));
        return phiMap;
    }

    public static ArrayList<Phi>[] getPhisForSuccessors(TerminatingInstruction terminatingInstruction, List<Phi> phis) {
        assert (phis != null);
        ArrayList[] phisPerSuccessor = new ArrayList[terminatingInstruction.getSuccessorCount()];
        for (int i = 0; i < phisPerSuccessor.length; ++i) {
            phisPerSuccessor[i] = new ArrayList();
        }
        for (Phi phi : phis) {
            LLVMPhiManager.assignPhiToSuccessor(terminatingInstruction, phi, phisPerSuccessor);
        }
        return phisPerSuccessor;
    }

    private static void assignPhiToSuccessor(TerminatingInstruction terminatingInstruction, Phi phi, ArrayList<Phi>[] phisPerSuccessor) {
        for (int i = 0; i < terminatingInstruction.getSuccessorCount(); ++i) {
            ArrayList<Phi> phis;
            if (terminatingInstruction.getSuccessor(i) != phi.getBlock() || LLVMPhiManager.hasMatchingPhi(phis = phisPerSuccessor[i], phi)) continue;
            phis.add(phi);
            return;
        }
        throw new LLVMParserException("Could not find a matching successor for a phi.");
    }

    private static boolean hasMatchingPhi(ArrayList<Phi> possiblePhiList, Phi phi) {
        for (Phi possiblePhi : possiblePhiList) {
            if (possiblePhi.getPhiValue() != phi.getPhiValue()) continue;
            return true;
        }
        return false;
    }

    public static final class Phi {
        private final InstructionBlock block;
        private final PhiInstruction phi;
        private final SymbolImpl value;

        private Phi(InstructionBlock block, PhiInstruction phi, SymbolImpl value) {
            this.block = block;
            this.phi = phi;
            this.value = value;
        }

        public InstructionBlock getBlock() {
            return this.block;
        }

        public PhiInstruction getPhiValue() {
            return this.phi;
        }

        public SymbolImpl getValue() {
            return this.value;
        }
    }

    private static class LLVMPhiManagerFunctionVisitor
    implements FunctionVisitor,
    InstructionVisitorAdapter {
        private static final Function<InstructionBlock, List<Phi>> PRODUCER = block -> new ArrayList();
        private final Map<InstructionBlock, List<Phi>> phiMap;
        private InstructionBlock currentBlock = null;

        LLVMPhiManagerFunctionVisitor(Map<InstructionBlock, List<Phi>> phiMap) {
            this.phiMap = phiMap;
        }

        @Override
        public void visit(InstructionBlock block) {
            this.currentBlock = block;
            block.accept(this);
        }

        @Override
        public void visit(PhiInstruction phi) {
            for (int i = 0; i < phi.getSize(); ++i) {
                InstructionBlock blk = phi.getBlock(i);
                List<Phi> references = this.phiMap.computeIfAbsent(blk, PRODUCER);
                references.add(new Phi(this.currentBlock, phi, phi.getValue(i)));
            }
        }
    }
}

