/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.cpu;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.ProfilingSettingsPresets;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.results.ResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.StackTraceSnapshotBuilder;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.sampler.truffle.AbstractSamplerSupport;
import org.graalvm.visualvm.sampler.truffle.cpu.CPUView;
import org.graalvm.visualvm.sampler.truffle.cpu.ThreadInfoProvider;
import org.openide.util.NbBundle;

public abstract class CPUSamplerSupport
extends AbstractSamplerSupport {
    private final Application application;
    private final ThreadInfoProvider threadInfoProvider;
    private final SnapshotDumper snapshotDumper;
    private final ThreadDumper threadDumper;
    private Timer timer;
    private TimerTask samplerTask;
    private final AbstractSamplerSupport.Refresher refresher;
    private int refreshRate;
    private StackTraceSnapshotBuilder builder;
    private volatile boolean sampleRunning;
    private final Object updateLock = new Object();
    private long currentLiveUpdate;
    private long lastLiveUpdate;
    private CPUView cpuView;
    private DataViewComponent.DetailsView[] detailsViews;

    public CPUSamplerSupport(Application application, ThreadInfoProvider tip, SnapshotDumper snapshotDumper, ThreadDumper threadDumper) {
        this.application = application;
        this.threadInfoProvider = tip;
        this.snapshotDumper = snapshotDumper;
        this.threadDumper = threadDumper;
        this.refreshRate = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        this.refresher = new AbstractSamplerSupport.Refresher(){

            @Override
            public void setRefreshRate(int rr) {
                CPUSamplerSupport.this.refreshRate = rr;
            }

            @Override
            public int getRefreshRate() {
                return CPUSamplerSupport.this.refreshRate;
            }

            @Override
            protected boolean checkRefresh() {
                return CPUSamplerSupport.this.samplerTask != null && CPUSamplerSupport.this.cpuView.isShowing();
            }

            @Override
            protected void doRefresh() {
                CPUSamplerSupport.this.doRefreshImpl();
            }
        };
    }

    @Override
    public DataViewComponent.DetailsView[] getDetailsView() {
        if (this.detailsViews == null) {
            this.cpuView = new CPUView(this.refresher, this.snapshotDumper, this.threadDumper, this.application);
            this.detailsViews = new DataViewComponent.DetailsView[1];
            this.detailsViews[0] = new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerSupport.class, (String)"LBL_Cpu_samples"), null, 10, (JComponent)this.cpuView, null);
        }
        this.cpuView.initSession();
        return (DataViewComponent.DetailsView[])this.detailsViews.clone();
    }

    @Override
    public boolean startSampling(ProfilingSettings settings, int samplingRate, int refreshRate) {
        GenericFilter sf = settings.getInstrumentationFilter();
        InstrumentationFilter filter = new InstrumentationFilter(sf);
        this.builder = this.snapshotDumper.getNewBuilder(filter);
        this.refresher.setRefreshRate(refreshRate);
        final StackTraceSnapshotBuilder _builder = this.builder;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CPUSamplerSupport.this.cpuView != null) {
                    CPUSamplerSupport.this.cpuView.setBuilder(_builder);
                    CPUSamplerSupport.this.cpuView.starting();
                }
            }
        });
        if (this.timer == null) {
            this.timer = this.getTimer();
        }
        this.samplerTask = new SamplerTask(this.builder);
        this.timer.scheduleAtFixedRate(this.samplerTask, 0L, (long)samplingRate);
        return true;
    }

    @Override
    public synchronized void stopSampling() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CPUSamplerSupport.this.cpuView != null) {
                    CPUSamplerSupport.this.cpuView.stopping();
                }
            }
        });
        if (this.samplerTask != null) {
            this.samplerTask.cancel();
            this.samplerTask = null;
        }
    }

    @Override
    public synchronized void terminate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CPUSamplerSupport.this.cpuView != null) {
                    CPUSamplerSupport.this.cpuView.terminated();
                }
            }
        });
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.builder = null;
    }

    private void doRefreshImpl() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CPUSamplerSupport.this.samplerTask == null) {
                    return;
                }
                if (!CPUSamplerSupport.this.sampleRunning) {
                    Object object = CPUSamplerSupport.this.updateLock;
                    synchronized (object) {
                        CPUSamplerSupport.this.lastLiveUpdate = CPUSamplerSupport.this.currentLiveUpdate;
                        CPUSamplerSupport.this.cpuView.refresh();
                    }
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
    }

    public static abstract class SnapshotDumper {
        private StackTraceSnapshotBuilder builder;

        StackTraceSnapshotBuilder getNewBuilder(InstrumentationFilter filter) {
            this.builder = new StackTraceSnapshotBuilder(1, filter);
            return this.builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final LoadedSnapshot takeNPSSnapshot(File directory) throws IOException, CPUResultsSnapshot.NoDataAvailableException {
            if (this.builder == null) {
                throw new IllegalStateException("Builder is null");
            }
            long time = System.currentTimeMillis();
            CPUResultsSnapshot snapshot = this.builder.createSnapshot(time);
            LoadedSnapshot ls = new LoadedSnapshot((ResultsSnapshot)snapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
            File file = Utils.getUniqueFile((File)directory, (String)ResultsManager.getDefault().getDefaultSnapshotFileName(ls), (String)".nps");
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
                ls.save(dos);
                ls.setFile(file);
                ls.setSaved(true);
            }
            return ls;
        }

        public abstract void takeSnapshot(boolean var1);
    }

    public static abstract class ThreadDumper {
        public abstract void takeThreadDump(boolean var1);
    }

    private class SamplerTask
    extends TimerTask {
        private final StackTraceSnapshotBuilder builder;
        private final Set samplingThreads = new HashSet();

        public SamplerTask(StackTraceSnapshotBuilder builder) {
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CPUSamplerSupport.this.sampleRunning) {
                return;
            }
            CPUSamplerSupport.this.sampleRunning = true;
            Object object = CPUSamplerSupport.this.updateLock;
            synchronized (object) {
                try {
                    Map[] infos = CPUSamplerSupport.this.threadInfoProvider.dumpAllThreads();
                    long timestamp = System.nanoTime();
                    Object samplingThreadName = null;
                    if (samplingThreadName != null && this.samplingThreads.add(samplingThreadName)) {
                        this.builder.setIgnoredThreads(this.samplingThreads);
                    }
                    this.addSourceNames(infos);
                    this.builder.addStacktrace(infos, timestamp);
                    CPUSamplerSupport.this.currentLiveUpdate = timestamp / 1000000L;
                    if (CPUSamplerSupport.this.currentLiveUpdate - CPUSamplerSupport.this.lastLiveUpdate >= (long)CPUSamplerSupport.this.refreshRate) {
                        CPUSamplerSupport.this.refresher.refresh();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    CPUSamplerSupport.this.terminate();
                }
                finally {
                    CPUSamplerSupport.this.sampleRunning = false;
                }
            }
        }

        private void addSourceNames(Map<String, Object>[] infoMap) {
            for (Map<String, Object> threadInfo : infoMap) {
                StackTraceElement[] stack = (StackTraceElement[])threadInfo.get("stack");
                for (int i = 0; i < stack.length; ++i) {
                    StackTraceElement ste = stack[i];
                    File file = new File(ste.getFileName());
                    String fname = file.getName();
                    String detailedName = ste.getMethodName() + "|(L" + fname + ":" + ste.getLineNumber() + ";)L;";
                    stack[i] = new StackTraceElement(ste.getClassName(), detailedName, ste.getFileName(), ste.getLineNumber());
                }
            }
        }
    }
}

